/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.ResourceOnFileSystem;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreResource;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.IllegalOpenParameterException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public abstract class URIDataStore
extends DataStore
implements StoreResource,
ResourceOnFileSystem {
    private final URI location;

    protected URIDataStore(DataStoreProvider dataStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        super(dataStoreProvider, storageConnector);
        this.location = storageConnector.getStorageAs(URI.class);
    }

    @Override
    public final DataStore getOriginator() {
        return this;
    }

    @Override
    public Path[] getComponentFiles() throws DataStoreException {
        Path path;
        if (this.location == null) {
            return new Path[0];
        }
        try {
            path = Paths.get(this.location);
        }
        catch (IllegalArgumentException | FileSystemNotFoundException runtimeException) {
            throw new DataStoreException(runtimeException);
        }
        return new Path[]{path};
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters(this.provider, this.location));
    }

    public static ParameterValueGroup parameters(DataStoreProvider dataStoreProvider, URI uRI) {
        if (uRI == null || dataStoreProvider == null) {
            return null;
        }
        ParameterValueGroup parameterValueGroup = dataStoreProvider.getOpenParameters().createValue();
        parameterValueGroup.parameter("location").setValue((Object)uRI);
        return parameterValueGroup;
    }

    public static Object location(Resource resource) throws DataStoreException {
        Path[] pathArray;
        if (resource instanceof DataStore && (pathArray = ((DataStore)resource).getOpenParameters()).isPresent()) {
            try {
                return ((ParameterValueGroup)pathArray.get()).parameter("location").getValue();
            }
            catch (ParameterNotFoundException parameterNotFoundException) {
                Logging.recoverableException(StoreUtilities.LOGGER, URIDataStore.class, "location", parameterNotFoundException);
            }
        }
        if (resource instanceof ResourceOnFileSystem && (pathArray = ((ResourceOnFileSystem)resource).getComponentFiles()) != null && pathArray.length != 0) {
            return pathArray[0];
        }
        return null;
    }

    protected final void addTitleOrIdentifier(MetadataBuilder metadataBuilder) {
        if (this.location != null) {
            metadataBuilder.addTitleOrIdentifier(IOUtilities.filenameWithoutExtension(super.getDisplayName()), MetadataBuilder.Scope.ALL);
        }
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        if (storeListener == null || clazz == null || clazz.isAssignableFrom(WarningEvent.class)) {
            super.addListener(clazz, storeListener);
        }
    }

    public static abstract class Provider
    extends DataStoreProvider {
        public static final ParameterDescriptor<URI> LOCATION_PARAM;
        public static final ParameterDescriptor<Boolean> CREATE_PARAM;
        public static final ParameterDescriptor<Charset> ENCODING;
        private volatile ParameterDescriptorGroup openDescriptor;

        protected Provider() {
        }

        @Override
        public final ParameterDescriptorGroup getOpenParameters() {
            ParameterDescriptorGroup parameterDescriptorGroup = this.openDescriptor;
            if (parameterDescriptorGroup == null) {
                this.openDescriptor = parameterDescriptorGroup = this.build((ParameterBuilder)new ParameterBuilder().addName((CharSequence)this.getShortName()));
            }
            return parameterDescriptorGroup;
        }

        protected ParameterDescriptorGroup build(ParameterBuilder parameterBuilder) {
            return parameterBuilder.createGroup(new GeneralParameterDescriptor[]{LOCATION_PARAM});
        }

        public static ParameterDescriptorGroup descriptor(String string) {
            return ((ParameterBuilder)new ParameterBuilder().addName((CharSequence)string)).createGroup(new GeneralParameterDescriptor[]{LOCATION_PARAM});
        }

        public static StorageConnector connector(DataStoreProvider dataStoreProvider, ParameterValueGroup parameterValueGroup) throws IllegalOpenParameterException {
            ParameterNotFoundException parameterNotFoundException = null;
            if (parameterValueGroup != null) {
                try {
                    Object object = parameterValueGroup.parameter("location").getValue();
                    if (object != null) {
                        return new StorageConnector(object);
                    }
                }
                catch (ParameterNotFoundException parameterNotFoundException2) {
                    parameterNotFoundException = parameterNotFoundException2;
                }
            }
            throw new IllegalOpenParameterException(Resources.format((short)27, dataStoreProvider.getShortName(), "location"), parameterNotFoundException);
        }

        static {
            ParameterBuilder parameterBuilder = new ParameterBuilder();
            ENCODING = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName((CharSequence)"encoding")).setDescription((CharSequence)Resources.formatInternational((short)29))).create(Charset.class, null);
            CREATE_PARAM = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName((CharSequence)"create")).setDescription((CharSequence)Resources.formatInternational((short)51))).create(Boolean.class, null);
            LOCATION_PARAM = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName((CharSequence)"location")).setDescription((CharSequence)Resources.formatInternational((short)31))).setRequired(true).create(URI.class, null);
        }
    }
}

