/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Servers {
    private Servers() {
    }

    public static List<InetSocketAddress> parse(String specs, int defaultPort) {
        ArrayList result = Lists.newArrayList();
        if (specs == null) {
            result.add(new InetSocketAddress("localhost", defaultPort));
        } else {
            String[] specStrings;
            for (String specString : specStrings = specs.split("[ ,]+")) {
                result.add(NetUtils.createSocketAddr(specString, defaultPort));
            }
        }
        return result;
    }
}

