/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Arrays;
import java.util.List;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.CRS;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.operation.CoordinateOperation;

final class CoordinateOperationSorter
implements Comparable<CoordinateOperationSorter> {
    private final CoordinateOperation operation;
    private final double area;
    private final double accuracy;

    private CoordinateOperationSorter(CoordinateOperation coordinateOperation, GeographicBoundingBox geographicBoundingBox) {
        this.operation = coordinateOperation;
        this.area = -Extents.area(Extents.intersection(geographicBoundingBox, Extents.getGeographicBoundingBox(coordinateOperation.getDomainOfValidity())));
        this.accuracy = CRS.getLinearAccuracy(coordinateOperation);
    }

    @Override
    public int compareTo(CoordinateOperationSorter coordinateOperationSorter) {
        int n = Double.compare(this.area, coordinateOperationSorter.area);
        if (n == 0) {
            n = Double.compare(this.accuracy, coordinateOperationSorter.accuracy);
        }
        return n;
    }

    static void sort(List<CoordinateOperation> list, GeographicBoundingBox geographicBoundingBox) {
        if (list.size() > 1) {
            int n;
            Object[] objectArray = new CoordinateOperationSorter[list.size()];
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = new CoordinateOperationSorter(list.get(n), geographicBoundingBox);
            }
            Arrays.sort(objectArray);
            list.clear();
            for (n = 0; n < objectArray.length; ++n) {
                list.add(((CoordinateOperationSorter)objectArray[n]).operation);
            }
        }
    }
}

