/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import thredds.catalog.ThreddsMetadata;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionUpdateType;
import ucar.coord.CoordinateRuntime;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.PartitionCollection;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;

@ThreadSafe
public class InvDatasetFcGrib
extends InvDatasetFeatureCollection {
    private static final String COLLECTION = "collection";
    private static final String GC_DATASET = GribCollection.Type.GC.toString();
    private static final String BEST_DATASET = GribCollection.Type.Best.toString();
    private static final String TWOD_DATASET = GribCollection.Type.TwoD.toString();
    private final FeatureCollectionConfig config;

    public InvDatasetFcGrib(InvDatasetImpl parent, String name, String path, FeatureCollectionType fcType, FeatureCollectionConfig config) {
        super(parent, name, path, fcType, config);
        this.config = config;
        Formatter errlog = new Formatter();
        CollectionSpecParser sp = new CollectionSpecParser(config.spec, errlog);
        this.topDirectory = sp.getRootDir();
        String errs = errlog.toString();
        if (errs.length() > 0) {
            this.logger.warn("{}: CollectionManager parse error = {} ", (Object)name, (Object)errs);
        }
        this.tmi.setDataType(FeatureType.GRID);
        this.state = new StateGrib(null);
        this.finish();
    }

    @Override
    public FeatureDataset getFeatureDataset() {
        return null;
    }

    @Override
    protected void firstInit() {
        super.firstInit();
    }

    @Override
    public void updateProto() {
    }

    @Override
    protected void updateCollection(InvDatasetFeatureCollection.State state, CollectionUpdateType force) {
        try {
            StateGrib localState = (StateGrib)state;
            GribCollection previous = localState.gribCollection;
            GribCollection previousLatest = localState.latest;
            localState.latest = null;
            localState.gribCollection = GribCdmIndex.openGribCollection(this.config, force, this.logger);
            if (localState.gribCollection == null) {
                this.logger.error("InvDatasetFcGrib.updateCollection failed " + this.config);
            }
            this.logger.debug("{}: GribCollection object was recreated", (Object)this.getName());
            if (previous != null) {
                previous.close();
            }
            if (previousLatest != null) {
                previousLatest.close();
            }
        }
        catch (IOException ioe) {
            this.logger.error("GribFc updateCollection", (Throwable)ioe);
        }
    }

    private InvCatalogImpl makeCatalogFromCollection(URI catURI, String parentName, GribCollection fromGc) throws IOException {
        InvCatalogImpl parentCatalog = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl result = new InvCatalogImpl(fromGc.getName(), parentCatalog.getVersion(), catURI);
        result.addService(this.virtualService);
        InvDatasetImpl ds = this.makeDatasetFromCollection(parentName, fromGc);
        result.addDataset(ds);
        result.finish();
        return result;
    }

    private InvDatasetImpl makeDatasetFromCollection(String parentName, GribCollection fromGc) {
        InvDatasetImpl result = new InvDatasetImpl(this);
        result.setName(fromGc.getName());
        result.setParent(null);
        InvDatasetImpl parent = (InvDatasetImpl)this.getParent();
        if (parent != null) {
            result.transferMetadata(parent, true);
        }
        String tpath = this.getPath() + "/" + COLLECTION;
        ThreddsMetadata tmi = result.getLocalMetadataInheritable();
        tmi.addVariableMapLink(this.makeMetadataLink(tpath, "?metadata=variableMap"));
        tmi.setServiceName("VirtualServices");
        String pathStart = parentName == null ? this.getPath() : this.getPath() + "/" + parentName;
        for (GribCollection.Dataset ds : fromGc.getDatasets()) {
            String path;
            Iterable<GribCollection.GroupGC> groups;
            boolean isSingleGroup;
            boolean bl = isSingleGroup = ds.getGroupsSize() == 1;
            if (ds.getType() == GribCollection.Type.TwoD) {
                groups = ds.getGroups();
                tmi.setGeospatialCoverage(this.extractGeospatial(groups));
                if (this.config.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.TwoD)) {
                    InvDatasetImpl twoD = new InvDatasetImpl(this, this.getDatasetNameTwoD());
                    path = pathStart + "/" + TWOD_DATASET;
                    twoD.setUrlPath(path);
                    twoD.tm.addDocumentation("summary", "Two time dimensions: reference and forecast; full access to all GRIB records");
                    twoD.tmi.addVariableMapLink(this.makeMetadataLink(path, "?metadata=variableMap"));
                    twoD.tmi.setTimeCoverage(this.extractCalendarDateRange(groups));
                    result.addDataset(twoD);
                    this.makeDatasetsFromGroups(twoD, groups, isSingleGroup);
                }
            }
            if (ds.getType() == GribCollection.Type.Best && this.config.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Best)) {
                groups = ds.getGroups();
                InvDatasetImpl best = new InvDatasetImpl(this, this.getDatasetNameBest(fromGc.getName()));
                path = pathStart + "/" + BEST_DATASET;
                best.setUrlPath(path);
                best.tm.addDocumentation("summary", "Single time dimension: for each forecast time, use GRIB record with smallest offset from reference time");
                best.tmi.addVariableMapLink(this.makeMetadataLink(path, "?metadata=variableMap"));
                best.tmi.setTimeCoverage(this.extractCalendarDateRange(groups));
                result.addDataset(best);
                this.makeDatasetsFromGroups(best, groups, isSingleGroup);
            }
            if (ds.getType() != GribCollection.Type.GC) continue;
            tmi.setServiceName("VirtualServices");
            CoordinateRuntime runCoord = fromGc.getMasterRuntime();
            assert (runCoord.getSize() == 1);
            CalendarDate runtime = runCoord.getFirstDate();
            path = pathStart + "/" + GC_DATASET;
            result.setUrlPath(path);
            Iterable<GribCollection.GroupGC> groups2 = ds.getGroups();
            result.tm.addDocumentation("summary", "Single reference time Grib Collection");
            result.tmi.addDocumentation("Reference Time", runtime.toString());
            result.tmi.addVariableMapLink(this.makeMetadataLink(path, "?metadata=variableMap"));
            result.tmi.setTimeCoverage(this.extractCalendarDateRange(groups2));
            this.makeDatasetsFromGroups(result, groups2, isSingleGroup);
        }
        if (fromGc instanceof PartitionCollection) {
            if (this.config.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Latest) && parentName == null) {
                InvDatasetImpl ds = new InvDatasetImpl(this, this.getDatasetNameLatest(fromGc.getName()));
                ds.setUrlPath("latest.xml");
                ds.setServiceName("latest");
                ds.finish();
                result.addDataset(ds);
            }
            PartitionCollection pc = (PartitionCollection)fromGc;
            for (PartitionCollection.Partition partition : pc.getPartitionsSorted()) {
                InvDatasetImpl partDs = this.makeDatasetFromPartition(this, parentName, partition, true);
                result.addDataset(partDs);
            }
        }
        result.finish();
        return result;
    }

    private void makeDatasetsFromGroups(InvDatasetImpl parent, Iterable<GribCollection.GroupGC> groups, boolean isSingleGroup) {
        for (GribCollection.GroupGC group : groups) {
            InvDatasetImpl ds = isSingleGroup ? parent : new InvDatasetImpl(this, group.getDescription());
            String groupId = isSingleGroup ? null : group.getId();
            String dpath = isSingleGroup ? parent.getUrlPath() : parent.getUrlPath() + "/" + groupId;
            ds.setID(dpath);
            ds.setUrlPath(dpath);
            if (!isSingleGroup) {
                parent.addDataset(ds);
            }
            ds.tmi.setGeospatialCoverage(this.extractGeospatial(group));
            ds.tmi.setTimeCoverage(group.getCalendarDateRange());
        }
    }

    private InvDatasetImpl makeDatasetFromPartition(InvDatasetImpl parent, String parentName, PartitionCollection.Partition partition, boolean isSingleGroup) {
        String dname = partition.getName();
        String startPath = parentName == null ? this.getPath() : this.getPath() + "/" + parentName;
        String dpath = startPath + "/" + dname;
        InvCatalogRef result = new InvCatalogRef(parent, dname, InvDatasetFcGrib.buildCatalogServiceHref(dpath));
        result.setID(dpath);
        result.setUrlPath(dpath);
        result.setServiceName("VirtualServices");
        return result;
    }

    @Override
    public InvCatalogImpl makeCatalog(String match, String reqPath, URI catURI) {
        StateGrib localState = (StateGrib)this.checkState();
        if (localState == null) {
            return null;
        }
        try {
            if (match == null || match.length() == 0) {
                return this.makeCatalogTop(catURI, localState);
            }
            if (localState.gribCollection instanceof PartitionCollection) {
                String[] paths = match.split("/");
                PartitionCollection pc = (PartitionCollection)localState.gribCollection;
                return this.drillPartitionCatalog(pc, paths, 0, catURI);
            }
        }
        catch (Exception e) {
            this.logger.error("Error making catalog for " + this.path, (Throwable)e);
        }
        return null;
    }

    private InvCatalogImpl drillPartitionCatalog(PartitionCollection pc, String[] paths, int idx, URI catURI) throws IOException {
        if (paths.length < idx + 1) {
            return null;
        }
        PartitionCollection.Partition pcp = pc.getPartitionByName(paths[idx]);
        if (pcp == null) {
            return null;
        }
        try (GribCollection gc = pcp.getGribCollection();){
            PartitionCollection pcNested;
            PartitionCollection.Partition pcpNested;
            if (paths.length > idx + 1 && gc instanceof PartitionCollection && (pcpNested = (pcNested = (PartitionCollection)gc).getPartitionByName(paths[idx + 1])) != null) {
                InvCatalogImpl invCatalogImpl = this.drillPartitionCatalog(pcNested, paths, idx + 1, catURI);
                return invCatalogImpl;
            }
            int i = 0;
            StringBuilder parentName = new StringBuilder();
            for (String s : paths) {
                if (i++ > 0) {
                    parentName.append("/");
                }
                parentName.append(s);
            }
            InvCatalogImpl invCatalogImpl = this.makeCatalogFromCollection(catURI, parentName.toString(), gc);
            return invCatalogImpl;
        }
    }

    @Override
    protected InvCatalogImpl makeCatalogTop(URI catURI, InvDatasetFeatureCollection.State localState) throws IOException, URISyntaxException {
        InvCatalogImpl parentCatalog = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl mainCatalog = new InvCatalogImpl(this.getName(), parentCatalog.getVersion(), catURI);
        if (this.config.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Latest)) {
            mainCatalog.addService(InvService.latest);
        }
        mainCatalog.addDataset(((StateGrib)localState).top);
        mainCatalog.addService(this.virtualService);
        mainCatalog.finish();
        return mainCatalog;
    }

    @Override
    protected void makeDatasetTop(InvDatasetFeatureCollection.State state) {
        StateGrib localState = (StateGrib)state;
        localState.top = this.makeDatasetFromCollection(null, localState.gribCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvCatalogImpl makeLatest(String matchPath, String reqPath, URI catURI) throws IOException {
        StateGrib localState = (StateGrib)this.checkState();
        if (!(localState.gribCollection instanceof PartitionCollection)) {
            return null;
        }
        PartitionCollection pc = (PartitionCollection)localState.gribCollection;
        if (localState.latest == null) {
            ArrayList<String> paths = new ArrayList<String>();
            GribCollection latest = pc.getLatestGribCollection(paths);
            if (latest == null) {
                return null;
            }
            latest.close();
            Formatter f = new Formatter();
            int count = 0;
            for (String p : paths) {
                if (count++ > 0) {
                    f.format("/", new Object[0]);
                }
                f.format("%s", p);
            }
            Object object = this.lock;
            synchronized (object) {
                localState.latest = latest;
                localState.latestPath = f.toString();
            }
        }
        try {
            return this.makeCatalogFromCollection(catURI, localState.latestPath, localState.latest);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ThreddsMetadata.GeospatialCoverage extractGeospatial(Iterable<GribCollection.GroupGC> groups) {
        ThreddsMetadata.GeospatialCoverage gcAll = null;
        for (GribCollection.GroupGC group : groups) {
            ThreddsMetadata.GeospatialCoverage gc = this.extractGeospatial(group);
            if (gcAll == null) {
                gcAll = gc;
                continue;
            }
            gcAll.extend(gc);
        }
        return gcAll;
    }

    private ThreddsMetadata.GeospatialCoverage extractGeospatial(GribCollection.GroupGC group) {
        GdsHorizCoordSys gdsCoordSys = group.getGdsHorizCoordSys();
        LatLonRect llbb = GridCoordSys.getLatLonBoundingBox(gdsCoordSys.proj, gdsCoordSys.getStartX(), gdsCoordSys.getStartY(), gdsCoordSys.getEndX(), gdsCoordSys.getEndY());
        ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
        if (llbb != null) {
            gc.setBoundingBox(llbb);
        }
        if (gdsCoordSys.isLatLon()) {
            gc.setLonResolution(gdsCoordSys.dx);
            gc.setLatResolution(gdsCoordSys.dy);
        }
        return gc;
    }

    private CalendarDateRange extractCalendarDateRange(Iterable<GribCollection.GroupGC> groups) {
        CalendarDateRange gcAll = null;
        for (GribCollection.GroupGC group : groups) {
            CalendarDateRange gc = group.getCalendarDateRange();
            if (gcAll == null) {
                gcAll = gc;
                continue;
            }
            gcAll.extend(gc);
        }
        return gcAll;
    }

    protected String getDatasetNameLatest(String gcName) {
        if (this.config.gribConfig != null && this.config.gribConfig.latestNamer != null) {
            return this.config.gribConfig.latestNamer;
        }
        return "Latest Reference Time Collection for " + gcName;
    }

    protected String getDatasetNameBest(String gcName) {
        if (this.config.gribConfig != null && this.config.gribConfig.bestNamer != null) {
            return this.config.gribConfig.bestNamer;
        }
        return "Best " + gcName + " Time Series";
    }

    protected String getDatasetNameTwoD() {
        return "Full Collection (Reference / Forecast Time) Dataset";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getFile(String remaining) {
        if (null == this.topDirectory) {
            return null;
        }
        StateGrib localState = (StateGrib)this.checkState();
        DatasetParse dp = null;
        try {
            dp = this.parse(remaining, localState);
            if (dp == null) {
                return super.getFile(remaining);
            }
            GribCollection gc = null;
            boolean isPartitionGc = false;
            try {
                if (dp.partition != null) {
                    gc = dp.partition.getGribCollection();
                    isPartitionGc = true;
                } else {
                    gc = localState.gribCollection;
                }
                List<String> files = gc.getFilenames();
                if (files.size() != 1) {
                    File file2 = null;
                    return file2;
                }
                File file = new File(files.get(0));
                return file;
            }
            finally {
                if (isPartitionGc) {
                    gc.close();
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to get file=" + remaining, (Throwable)e);
            return null;
        }
    }

    @Override
    public GridDataset getGridDataset(String matchPath) throws IOException {
        StateGrib localState = (StateGrib)this.checkState();
        DatasetParse dp = this.parse(matchPath, localState);
        if (dp == null) {
            return null;
        }
        if (dp.filename != null) {
            File want = new File(this.topDirectory, dp.filename);
            NetcdfDataset ncd = NetcdfDataset.acquireDataset(null, want.getPath(), null, -1, null, this.config.gribConfig.getIospMessage());
            return new GridDataset(ncd);
        }
        if (dp.partition != null) {
            try (GribCollection gc = dp.partition.getGribCollection();){
                GridDataset gridDataset = gc.getGridDataset(dp.ds, dp.group, dp.filename, this.config, null, this.logger);
                return gridDataset;
            }
        }
        return localState.gribCollection.getGridDataset(dp.ds, dp.group, dp.filename, this.config, null, this.logger);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(String matchPath) throws IOException {
        StateGrib localState = (StateGrib)this.checkState();
        DatasetParse dp = this.parse(matchPath, localState);
        if (dp == null) {
            return null;
        }
        if (dp.filename != null) {
            File want = new File(this.topDirectory, dp.filename);
            return NetcdfDataset.acquireDataset(null, want.getPath(), null, -1, null, this.config.gribConfig.getIospMessage());
        }
        if (dp.partition != null) {
            try (GribCollection gc = dp.partition.getGribCollection();){
                NetcdfDataset netcdfDataset = gc.getNetcdfDataset(dp.ds, dp.group, dp.filename, this.config, null, this.logger);
                return netcdfDataset;
            }
        }
        return localState.gribCollection.getNetcdfDataset(dp.ds, dp.group, dp.filename, this.config, null, this.logger);
    }

    private DatasetParse parse(String matchPath, StateGrib localState) throws IOException {
        if (matchPath == null || matchPath.length() == 0) {
            return null;
        }
        String[] paths = matchPath.split("/");
        if (paths.length < 1) {
            return null;
        }
        GribCollection.Dataset ds = localState.gribCollection.findDataset(paths[0]);
        if (ds != null) {
            boolean isSingleGroup;
            boolean bl = isSingleGroup = ds.getGroupsSize() == 1;
            if (paths.length == 1) {
                if (!isSingleGroup) {
                    return null;
                }
                GribCollection.GroupGC g = ds.getGroup(0);
                return new DatasetParse(null, localState.gribCollection, ds, g);
            }
            if (paths.length == 2) {
                String groupName = paths[1];
                GribCollection.GroupGC g = ds.findGroupById(groupName);
                if (g != null) {
                    return new DatasetParse(null, localState.gribCollection, ds, g);
                }
                return null;
            }
        }
        if (paths.length < 2) {
            return null;
        }
        if (!(localState.gribCollection instanceof PartitionCollection)) {
            return null;
        }
        PartitionCollection pc = (PartitionCollection)localState.gribCollection;
        return this.drill(pc, paths, 0);
    }

    private DatasetParse drill(PartitionCollection pc, String[] paths, int idx) throws IOException {
        if (paths.length <= idx + 1) {
            return null;
        }
        PartitionCollection.Partition pcp = pc.getPartitionByName(paths[idx]);
        if (pcp == null) {
            return null;
        }
        try (GribCollection gc = pcp.getGribCollection();){
            GribCollection.GroupGC g;
            PartitionCollection pcNested;
            PartitionCollection.Partition pcpNested;
            if (gc instanceof PartitionCollection && (pcpNested = (pcNested = (PartitionCollection)gc).getPartitionByName(paths[idx + 1])) != null) {
                DatasetParse datasetParse = this.drill(pcNested, paths, idx + 1);
                return datasetParse;
            }
            String datasetName = paths[idx + 1];
            GribCollection.Dataset ds = gc.findDataset(datasetName);
            if (ds == null) {
                DatasetParse datasetParse = null;
                return datasetParse;
            }
            GribCollection.GroupGC groupGC = g = paths.length <= idx + 2 ? ds.getGroup(0) : ds.findGroupById(paths[idx + 2]);
            if (g == null) {
                DatasetParse datasetParse = null;
                return datasetParse;
            }
            DatasetParse datasetParse = new DatasetParse(pcp, gc, ds, g);
            return datasetParse;
        }
    }

    private static class DatasetParse {
        final PartitionCollection.Partition partition;
        final GribCollection gc;
        final GribCollection.Dataset ds;
        final GribCollection.GroupGC group;
        final String filename;

        private DatasetParse(PartitionCollection.Partition tpp, GribCollection gc, GribCollection.Dataset ds, GribCollection.GroupGC group) {
            this.partition = tpp;
            this.gc = gc;
            this.ds = ds;
            this.group = group;
            this.filename = null;
        }
    }

    protected class StateGrib
    extends InvDatasetFeatureCollection.State {
        GribCollection gribCollection;
        GribCollection latest;
        String latestPath;

        protected StateGrib(StateGrib from) {
            super(InvDatasetFcGrib.this, from);
            if (from != null) {
                this.gribCollection = from.gribCollection;
                this.latest = from.latest;
                this.latestPath = from.latestPath;
            }
        }

        @Override
        public InvDatasetFeatureCollection.State copy() {
            return new StateGrib(this);
        }
    }
}

