/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl.compatibility;

import java.io.IOException;
import java.util.HashMap;
import org.apache.uima.UIMA_UnsupportedOperationException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.impl.AnalysisEngineDescription_impl;
import org.apache.uima.analysis_engine.impl.compatibility.AnnotatorAdapter;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.impl.ProcessTrace_impl;

public class CasConsumerAdapter
implements AnalysisComponent {
    private CasConsumer mCasConsumer;
    private TypeSystem mLastTypeSystem;
    private AnalysisEngineMetaData mMetaData;

    public CasConsumerAdapter(CasConsumer aCasConsumer, AnalysisEngineMetaData aMetaData) {
        this.mCasConsumer = aCasConsumer;
        this.mMetaData = aMetaData;
    }

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        AnalysisEngineDescription_impl desc = new AnalysisEngineDescription_impl();
        desc.setMetaData(this.mMetaData);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("UIMA_CONTEXT", aContext);
        this.mCasConsumer.initialize(desc, paramsMap);
    }

    @Override
    public void process(AbstractCas aCAS) throws AnalysisEngineProcessException {
        if (!CAS.class.isAssignableFrom(aCAS.getClass())) {
            throw new AnalysisEngineProcessException("incorrect_cas_interface", new Object[]{CAS.class, aCAS.getClass()});
        }
        this.checkTypeSystemChange(aCAS);
        try {
            this.mCasConsumer.processCas((CAS)aCAS);
        }
        catch (ResourceProcessException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    public void checkTypeSystemChange(AbstractCas aCAS) throws AnalysisEngineProcessException {
        try {
            TypeSystem typeSystem = aCAS instanceof JCas ? ((JCas)aCAS).getTypeSystem() : ((CAS)aCAS).getTypeSystem();
            if (typeSystem != this.mLastTypeSystem) {
                this.mCasConsumer.typeSystemInit(typeSystem);
                this.mLastTypeSystem = typeSystem;
            }
        }
        catch (ResourceInitializationException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    @Override
    public void batchProcessComplete() throws AnalysisEngineProcessException {
        try {
            this.mCasConsumer.batchProcessComplete(new ProcessTrace_impl());
        }
        catch (ResourceProcessException e) {
            throw new AnalysisEngineProcessException(e);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        try {
            this.mCasConsumer.collectionProcessComplete(new ProcessTrace_impl());
        }
        catch (ResourceProcessException e) {
            throw new AnalysisEngineProcessException(e);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    @Override
    public void destroy() {
        this.mCasConsumer.destroy();
    }

    @Override
    public void reconfigure() throws ResourceConfigurationException, ResourceInitializationException {
        this.mCasConsumer.reconfigure();
    }

    @Override
    public boolean hasNext() throws AnalysisEngineProcessException {
        return false;
    }

    @Override
    public AbstractCas next() throws AnalysisEngineProcessException {
        throw new UIMA_UnsupportedOperationException("unsupported_method", new Object[]{AnnotatorAdapter.class, "next"});
    }

    public Class<CAS> getRequiredCasInterface() {
        return CAS.class;
    }

    @Override
    public int getCasInstancesRequired() {
        return 0;
    }

    @Override
    public void setResultSpecification(ResultSpecification aResultSpec) {
    }
}

