/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.Collections;
import java.util.Set;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;

class DeleteReplicaSuggester
extends Suggester {
    DeleteReplicaSuggester() {
    }

    @Override
    public CollectionParams.CollectionAction getAction() {
        return CollectionParams.CollectionAction.DELETEREPLICA;
    }

    @Override
    SolrRequest init() {
        Set shards = this.hints.getOrDefault((Object)Suggester.Hint.COLL_SHARD, Collections.emptySet());
        if (shards.isEmpty()) {
            throw new RuntimeException("delete-replica requires 'collection' and 'shard'");
        }
        if (shards.size() > 1) {
            throw new RuntimeException("delete-replica requires exactly one pair of 'collection' and 'shard'");
        }
        Pair collShard = (Pair)shards.iterator().next();
        Set counts = this.hints.getOrDefault((Object)Suggester.Hint.NUMBER, Collections.emptySet());
        Integer count = null;
        if (!counts.isEmpty()) {
            if (counts.size() > 1) {
                throw new RuntimeException("delete-replica allows at most one number hint specifying the number of replicas to delete");
            }
            Number n = (Number)counts.iterator().next();
            count = n.intValue();
        }
        Set replicas = this.hints.getOrDefault((Object)Suggester.Hint.REPLICA, Collections.emptySet());
        String replica = null;
        if (!replicas.isEmpty()) {
            if (replicas.size() > 1) {
                throw new RuntimeException("delete-replica allows at most one 'replica' hint");
            }
            replica = (String)replicas.iterator().next();
        }
        if (replica == null && count == null) {
            throw new RuntimeException("delete-replica requires either 'replica' or 'number' hint");
        }
        if (replica != null) {
            return CollectionAdminRequest.deleteReplica((String)collShard.first(), (String)collShard.second(), replica);
        }
        return CollectionAdminRequest.deleteReplica((String)collShard.first(), (String)collShard.second(), count);
    }
}

