/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;

@InterfaceAudience.Private
public interface INodeAttributes {
    public byte[] getLocalNameBytes();

    public String getUserName();

    public String getGroupName();

    public FsPermission getFsPermission();

    public short getFsPermissionShort();

    public long getPermissionLong();

    public AclFeature getAclFeature();

    public XAttrFeature getXAttrFeature();

    public long getModificationTime();

    public long getAccessTime();

    public static abstract class SnapshotCopy
    implements INodeAttributes {
        private final byte[] name;
        private final long permission;
        private final AclFeature aclFeature;
        private final long modificationTime;
        private final long accessTime;
        private XAttrFeature xAttrFeature;

        SnapshotCopy(byte[] name, PermissionStatus permissions, AclFeature aclFeature, long modificationTime, long accessTime, XAttrFeature xAttrFeature) {
            this.name = name;
            this.permission = INodeWithAdditionalFields.PermissionStatusFormat.toLong(permissions);
            this.aclFeature = aclFeature;
            this.modificationTime = modificationTime;
            this.accessTime = accessTime;
            this.xAttrFeature = xAttrFeature;
        }

        SnapshotCopy(INode inode) {
            this.name = inode.getLocalNameBytes();
            this.permission = inode.getPermissionLong();
            this.aclFeature = inode.getAclFeature();
            this.modificationTime = inode.getModificationTime();
            this.accessTime = inode.getAccessTime();
            this.xAttrFeature = inode.getXAttrFeature();
        }

        @Override
        public final byte[] getLocalNameBytes() {
            return this.name;
        }

        @Override
        public final String getUserName() {
            return INodeWithAdditionalFields.PermissionStatusFormat.getUser(this.permission);
        }

        @Override
        public final String getGroupName() {
            return INodeWithAdditionalFields.PermissionStatusFormat.getGroup(this.permission);
        }

        @Override
        public final FsPermission getFsPermission() {
            return new FsPermission(this.getFsPermissionShort());
        }

        @Override
        public final short getFsPermissionShort() {
            return INodeWithAdditionalFields.PermissionStatusFormat.getMode(this.permission);
        }

        @Override
        public long getPermissionLong() {
            return this.permission;
        }

        @Override
        public AclFeature getAclFeature() {
            return this.aclFeature;
        }

        @Override
        public final long getModificationTime() {
            return this.modificationTime;
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public final XAttrFeature getXAttrFeature() {
            return this.xAttrFeature;
        }
    }
}

