/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;

public class SafariOptions
extends MutableCapabilities {
    public static final String CAPABILITY = "safari.options";
    private Map<String, Object> options = new TreeMap<String, Object>();

    public SafariOptions() {
        this.setUseTechnologyPreview(false);
        this.setCapability("browserName", "safari");
    }

    public SafariOptions(Capabilities source) {
        this();
        source.asMap().forEach((key, value) -> {
            if (CAPABILITY.equals(key) && value instanceof Map) {
                Map map = (Map)value;
                this.options.putAll(map);
            } else if (value != null) {
                this.setCapability((String)key, value);
            }
        });
    }

    public SafariOptions merge(Capabilities extraCapabilities) {
        super.merge(extraCapabilities);
        return this;
    }

    public static SafariOptions fromCapabilities(Capabilities capabilities) throws WebDriverException {
        if (capabilities instanceof SafariOptions) {
            return (SafariOptions)capabilities;
        }
        Object cap = capabilities.getCapability(CAPABILITY);
        if (cap instanceof SafariOptions) {
            return (SafariOptions)((Object)cap);
        }
        if (cap instanceof Map) {
            return SafariOptions.fromJsonMap((Map)cap);
        }
        return new SafariOptions();
    }

    @Deprecated
    public SafariOptions useCleanSession(boolean useCleanSession) {
        this.options.put("cleanSession", useCleanSession);
        return this;
    }

    public SafariOptions setUseTechnologyPreview(boolean useTechnologyPreview) {
        this.options.put("technologyPreview", useTechnologyPreview);
        return this;
    }

    public void setCapability(String key, Object value) {
        if ("technologyPreview".equals(key)) {
            this.setUseTechnologyPreview(Boolean.valueOf(value.toString()));
        } else {
            super.setCapability(key, value);
        }
    }

    public void setCapability(String key, boolean value) {
        if ("technologyPreview".equals(key)) {
            this.setUseTechnologyPreview(value);
        } else {
            super.setCapability(key, value);
        }
    }

    public SafariOptions setProxy(Proxy proxy) {
        this.setCapability("proxy", proxy);
        return this;
    }

    public boolean getUseTechnologyPreview() {
        return (Boolean)this.options.getOrDefault("technologyPreview", false);
    }

    private static SafariOptions fromJsonMap(Map<?, ?> options) {
        SafariOptions safariOptions = new SafariOptions();
        Boolean useTechnologyPreview = (Boolean)options.get("technologyPreview");
        if (useTechnologyPreview != null) {
            safariOptions.setUseTechnologyPreview(useTechnologyPreview);
        }
        return safariOptions;
    }

    protected int amendHashCode() {
        return this.options.hashCode();
    }

    public Map<String, Object> asMap() {
        return ImmutableSortedMap.naturalOrder().putAll(super.asMap()).put((Object)CAPABILITY, this.options).build();
    }

    private static interface Option {
        public static final String CLEAN_SESSION = "cleanSession";
        public static final String TECHNOLOGY_PREVIEW = "technologyPreview";
    }
}

