/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.mongodboutput;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBPort;
import com.mongodb.DBPortPool;
import com.mongodb.DBTCPConnector;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.BaseOutputConnector;
import org.apache.manifoldcf.agents.output.mongodboutput.Messages;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.VersionContext;
import org.apache.manifoldcf.crawler.system.Logging;
import org.bson.types.Binary;

public class MongodbOutputConnector
extends BaseOutputConnector {
    private static final String MONGODB_TAB_PARAMETERS = "MongodbConnector.Parameters";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration.js";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_Parameters.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration.html";
    protected static final String ACTIVITY_INJECTION = "Injection";
    protected static final String ACTIVITY_DELETE = "Delete";
    private static final int DOCUMENT_STATUS_ACCEPTED = 0;
    private static final String DOCUMENT_STATUS_ACCEPTED_DESC = "Injection OK - ";
    private static final String DOCUMENT_STATUS_REJECTED_DESC = "Injection KO - ";
    private static final int DOCUMENT_STATUS_REJECTED = 1;
    private static final String DOCUMENT_DELETION_STATUS_ACCEPTED = "Remove request accepted";
    private static final String DOCUMENT_DELETION_STATUS_REJECTED = "Remove request rejected";
    protected String host = null;
    protected String port = null;
    protected String database = null;
    protected String collection = null;
    protected String username = null;
    protected String password = null;
    protected static final long timeToRelease = 300000L;
    protected long lastSessionFetch = -1L;
    private MongoClient client = null;
    private DB mongoDatabase = null;

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_INJECTION, ACTIVITY_DELETE};
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            DestroySessionThread t = new DestroySessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    throw (Error)thr;
                }
                this.client = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.client = null;
                this.lastSessionFetch = -1L;
                Logging.connectors.warn((Object)("MongoDB: Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean isConnected() {
        if (this.client == null) {
            return false;
        }
        DBTCPConnector currentTCPConnection = this.client.getConnector();
        return currentTCPConnection.isOpen();
    }

    private static void outputResource(String resName, IHTTPOutput out, Locale locale, Map<String, String> paramMap) throws ManifoldCFException {
        Messages.outputResourceWithVelocity(out, locale, resName, paramMap, true);
    }

    private static void fillInServerConfigurationMap(Map<String, String> newMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String username = parameters.getParameter("username");
        String password = parameters.getParameter("password");
        String host = parameters.getParameter("host");
        String port = parameters.getParameter("port");
        String database = parameters.getParameter("database");
        String collection = parameters.getParameter("collection");
        if (username == null) {
            username = "";
        }
        password = password == null ? "" : mapper.mapPasswordToKey(password);
        if (host == null) {
            host = "localhost";
        }
        if (port == null) {
            port = "27017";
        }
        if (database == null) {
            database = "database";
        }
        if (collection == null) {
            collection = "collection";
        }
        newMap.put("username", username);
        newMap.put("password", password);
        newMap.put("host", host);
        newMap.put("port", port);
        newMap.put("database", database);
        newMap.put("collection", collection);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        MongodbOutputConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        MongodbOutputConnector.outputResource(VIEW_CONFIG_FORWARD, out, locale, paramMap);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, MONGODB_TAB_PARAMETERS));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        MongodbOutputConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        MongodbOutputConnector.outputResource(EDIT_CONFIG_HEADER_FORWARD, out, locale, paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TabName", tabName);
        MongodbOutputConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        MongodbOutputConnector.outputResource(EDIT_CONFIG_FORWARD_SERVER, out, locale, paramMap);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String collection;
        String database;
        String port;
        String host;
        String password;
        String username = variableContext.getParameter("username");
        if (username != null) {
            parameters.setParameter("username", username);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setParameter("password", variableContext.mapKeyToPassword(password));
        }
        if ((host = variableContext.getParameter("host")) != null) {
            parameters.setParameter("host", host);
        }
        if ((port = variableContext.getParameter("port")) != null && !StringUtils.isEmpty((String)port)) {
            try {
                Integer.parseInt(port);
                parameters.setParameter("port", port);
            }
            catch (NumberFormatException e) {
                return "Invalid Port Number";
            }
        }
        if ((database = variableContext.getParameter("database")) != null) {
            parameters.setParameter("database", database);
        }
        if ((collection = variableContext.getParameter("collection")) != null) {
            parameters.setParameter("collection", collection);
        }
        return null;
    }

    public void disconnect() throws ManifoldCFException {
        if (this.client != null) {
            DestroySessionThread t = new DestroySessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    throw (Error)thr;
                }
                this.client = null;
                this.mongoDatabase = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.client = null;
                this.mongoDatabase = null;
                this.lastSessionFetch = -1L;
                Logging.connectors.warn((Object)("MongoDB: Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
        }
        this.username = null;
        this.password = null;
        this.host = null;
        this.port = null;
        this.database = null;
        this.collection = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.username = this.params.getParameter("username");
        this.password = this.params.getParameter("password");
        this.host = this.params.getParameter("host");
        this.port = this.params.getParameter("port");
        this.database = this.params.getParameter("database");
        this.collection = this.params.getParameter("collection");
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (StringUtils.isEmpty((String)this.database)) {
            throw new ManifoldCFException("Parameter database required but not set");
        }
        if (StringUtils.isEmpty((String)this.collection)) {
            throw new ManifoldCFException("Parameter collection required but not set");
        }
        GetSessionThread t = new GetSessionThread();
        try {
            t.start();
            t.join();
            Throwable thr = t.getException();
            if (thr != null) {
                if (thr instanceof ManifoldCFException) {
                    throw new ManifoldCFException("MongoDB: Error during getting a new session: " + thr.getMessage(), thr);
                }
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof MongoException) {
                    throw new ManifoldCFException("MongoDB: Error during getting a new session: " + thr.getMessage(), thr);
                }
                if (thr instanceof ConnectException) {
                    throw new ManifoldCFException("MongoDB: Error Connecting to MongoDB is mongod running? : " + thr.getMessage(), thr);
                }
                throw (Error)thr;
            }
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (RemoteException e) {
            Throwable e2 = e.getCause();
            if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                throw new ManifoldCFException(e2.getMessage(), e2, 2);
            }
            Logging.connectors.warn((Object)("MongoDB: Transient remote exception creating session: " + e.getMessage()), (Throwable)e);
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption(e.getMessage(), currentTime + 60000L);
        }
        this.lastSessionFetch = System.currentTimeMillis();
    }

    protected void releaseCheck() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            DestroySessionThread t = new DestroySessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    throw (Error)thr;
                }
                this.client = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.client = null;
                this.lastSessionFetch = -1L;
                Logging.connectors.warn((Object)("MongoDB: Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void checkConnection() throws ManifoldCFException, ServiceInterruption {
        while (true) {
            boolean noSession = this.client == null;
            this.getSession();
            CheckConnectionThread t = new CheckConnectionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    if (thr instanceof ConnectException) {
                        throw new ManifoldCFException("MongoDB: Error during checking connection: is Mongod running?" + thr.getMessage(), thr);
                    }
                    if (thr instanceof MongoException) {
                        throw new ManifoldCFException("MongoDB: Error during checking connection: " + thr.getMessage(), thr);
                    }
                    if (thr instanceof ManifoldCFException) {
                        throw new ManifoldCFException(thr.getMessage(), thr);
                    }
                    throw (Error)thr;
                }
                return;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to filenet service: " + e.getMessage(), currentTime + 60000L);
                }
                this.client = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        this.getSession();
        this.client.setWriteConcern(WriteConcern.SAFE);
        long startTime = System.currentTimeMillis();
        String resultDescription = "";
        String fileName = document.getFileName();
        Long binaryLength = document.getBinaryLength();
        String mimeType = document.getMimeType();
        Date creationDate = document.getCreatedDate();
        Date lastModificationDate = document.getModifiedDate();
        Date indexingDate = document.getIndexingDate();
        String primaryPath = "";
        List sourcePath = document.getSourcePath();
        if (sourcePath != null && !sourcePath.isEmpty()) {
            primaryPath = (String)sourcePath.get(0);
        }
        InputStream inputStream = document.getBinaryStream();
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            Binary content = new Binary(bytes);
            DBCollection mongoCollection = this.mongoDatabase.getCollection(this.collection);
            BasicDBObject newDocument = new BasicDBObject();
            newDocument.append("fileName", (Object)fileName).append("creationDate", (Object)creationDate).append("lastModificationDate", (Object)lastModificationDate).append("indexingDate", (Object)indexingDate).append("binaryLength", (Object)binaryLength).append("documentURI", (Object)documentURI).append("mimeType", (Object)mimeType).append("content", (Object)content).append("primaryPath", (Object)primaryPath);
            Iterator i = document.getFields();
            while (i.hasNext()) {
                String fieldName = (String)i.next();
                Date[] dateFieldValues = document.getFieldAsDates(fieldName);
                if (dateFieldValues != null) {
                    newDocument.append(fieldName, (Object)dateFieldValues);
                    continue;
                }
                String[] fieldValues = document.getFieldAsStrings(fieldName);
                newDocument.append(fieldName, (Object)fieldValues);
            }
            BasicDBObject searchQuery = new BasicDBObject().append("documentURI", (Object)documentURI);
            DBCursor cursor = mongoCollection.find((DBObject)searchQuery);
            Long numberOfDocumentsBeforeInsert = mongoCollection.count();
            WriteResult result = cursor.count() > 0 ? mongoCollection.update((DBObject)searchQuery, (DBObject)newDocument) : mongoCollection.insert(new DBObject[]{newDocument});
            Long numberOfDocumentsAfterInsert = mongoCollection.count();
            Long numberOfDocumentsInserted = numberOfDocumentsAfterInsert - numberOfDocumentsBeforeInsert;
            Long numberOfDocumentsIndexed = numberOfDocumentsInserted != 0L ? numberOfDocumentsInserted : (long)result.getN();
            Logging.connectors.info((Object)("Number of documents indexed : " + numberOfDocumentsIndexed));
            if (numberOfDocumentsIndexed > 0L) {
                resultDescription = DOCUMENT_STATUS_ACCEPTED_DESC;
                int n = 0;
                return n;
            }
            resultDescription = DOCUMENT_STATUS_REJECTED_DESC;
            int n = 1;
            return n;
        }
        catch (MongoException e) {
            resultDescription = DOCUMENT_STATUS_REJECTED_DESC;
            Logging.connectors.info((Object)("MongoDB: Error inserting or updating : " + e.getMessage()));
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            resultDescription = DOCUMENT_STATUS_REJECTED_DESC;
            Logging.connectors.info((Object)("Error converting the input stream to byte array : " + e.getMessage()));
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            resultDescription = DOCUMENT_STATUS_REJECTED_DESC;
            Logging.connectors.info((Object)("Error encoding content : " + e.getMessage()));
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            activities.recordActivity(Long.valueOf(startTime), ACTIVITY_INJECTION, Long.valueOf(document.getBinaryLength()), documentURI, resultDescription, resultDescription);
        }
    }

    public void removeDocument(String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        long startTime = System.currentTimeMillis();
        String resultDescription = "";
        try {
            DBCollection mongoCollection = this.mongoDatabase.getCollection(this.collection);
            BasicDBObject query = new BasicDBObject();
            query.append("documentURI", (Object)documentURI);
            WriteResult result = mongoCollection.remove((DBObject)query);
            Logging.connectors.info((Object)("Number of documents deleted : " + result.getN()));
            resultDescription = result.getN() > 0 ? DOCUMENT_DELETION_STATUS_ACCEPTED : DOCUMENT_DELETION_STATUS_REJECTED;
        }
        catch (Exception e) {
            resultDescription = DOCUMENT_DELETION_STATUS_REJECTED;
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
        finally {
            activities.recordActivity(Long.valueOf(startTime), ACTIVITY_DELETE, null, documentURI, null, resultDescription);
        }
    }

    protected class DestroySessionThread
    extends Thread {
        protected Throwable exception = null;

        public DestroySessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                MongodbOutputConnector.this.client = null;
                MongodbOutputConnector.this.mongoDatabase = null;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class CheckConnectionThread
    extends Thread {
        protected Throwable exception = null;

        public CheckConnectionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                if (MongodbOutputConnector.this.client != null) {
                    DBTCPConnector dbtcpConnector = MongodbOutputConnector.this.client.getConnector();
                    DBPortPool dbPortPool = dbtcpConnector.getDBPortPool(MongodbOutputConnector.this.client.getAddress());
                    DBPort dbPort = dbPortPool.get();
                    dbPort.ensureOpen();
                    MongodbOutputConnector.this.client = null;
                }
            }
            catch (Throwable e) {
                Logging.connectors.warn((Object)("MongoDB: Error checking repository: " + e.getMessage()), e);
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class GetSessionThread
    extends Thread {
        protected Throwable exception = null;

        public GetSessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block19: {
                try {
                    int integerPort;
                    if (MongodbOutputConnector.this.client != null) break block19;
                    if (StringUtils.isEmpty((String)MongodbOutputConnector.this.host) && StringUtils.isEmpty((String)MongodbOutputConnector.this.port)) {
                        try {
                            MongodbOutputConnector.this.client = new MongoClient();
                            MongodbOutputConnector.this.mongoDatabase = MongodbOutputConnector.this.client.getDB(MongodbOutputConnector.this.database);
                        }
                        catch (UnknownHostException ex) {
                            throw new ManifoldCFException("MongoDB: Default host is not found. Is mongod process running?" + ex.getMessage(), (Throwable)ex);
                        }
                    }
                    if (!StringUtils.isEmpty((String)MongodbOutputConnector.this.host) && StringUtils.isEmpty((String)MongodbOutputConnector.this.port)) {
                        try {
                            MongodbOutputConnector.this.client = new MongoClient(MongodbOutputConnector.this.host);
                            MongodbOutputConnector.this.mongoDatabase = MongodbOutputConnector.this.client.getDB(MongodbOutputConnector.this.database);
                        }
                        catch (UnknownHostException ex) {
                            throw new ManifoldCFException("MongoDB: Given host information is not valid or mongod process doesn't run" + ex.getMessage(), (Throwable)ex);
                        }
                    }
                    if (!StringUtils.isEmpty((String)MongodbOutputConnector.this.host) && !StringUtils.isEmpty((String)MongodbOutputConnector.this.port)) {
                        try {
                            integerPort = Integer.parseInt(MongodbOutputConnector.this.port);
                            MongodbOutputConnector.this.client = new MongoClient(MongodbOutputConnector.this.host, integerPort);
                            MongodbOutputConnector.this.mongoDatabase = MongodbOutputConnector.this.client.getDB(MongodbOutputConnector.this.database);
                        }
                        catch (UnknownHostException ex) {
                            throw new ManifoldCFException("MongoDB: Given information is not valid or mongod process doesn't run" + ex.getMessage(), (Throwable)ex);
                        }
                        catch (NumberFormatException ex) {
                            throw new ManifoldCFException("MongoDB: Given port is not a valid number. " + ex.getMessage(), (Throwable)ex);
                        }
                    }
                    if (StringUtils.isEmpty((String)MongodbOutputConnector.this.host) && !StringUtils.isEmpty((String)MongodbOutputConnector.this.port)) {
                        try {
                            integerPort = Integer.parseInt(MongodbOutputConnector.this.port);
                            MongodbOutputConnector.this.client = new MongoClient("localhost", integerPort);
                            MongodbOutputConnector.this.mongoDatabase = MongodbOutputConnector.this.client.getDB(MongodbOutputConnector.this.database);
                        }
                        catch (UnknownHostException e) {
                            Logging.connectors.warn((Object)("MongoDB: Given information is not valid or mongod process doesn't run" + e.getMessage()), (Throwable)e);
                            throw new ManifoldCFException("MongoDB: Given information is not valid or mongod process doesn't run" + e.getMessage(), (Throwable)e);
                        }
                        catch (NumberFormatException e) {
                            Logging.connectors.warn((Object)("MongoDB: Given port is not valid number. " + e.getMessage()), (Throwable)e);
                            throw new ManifoldCFException("MongoDB: Given port is not valid number. " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (!StringUtils.isEmpty((String)MongodbOutputConnector.this.username) && !StringUtils.isEmpty((String)MongodbOutputConnector.this.password)) {
                        boolean auth = MongodbOutputConnector.this.mongoDatabase.authenticate(MongodbOutputConnector.this.username, MongodbOutputConnector.this.password.toCharArray());
                        if (!auth) {
                            Logging.connectors.warn((Object)"MongoDB:Authentication Error! Given database username and password doesn't match for the database given.");
                            throw new ManifoldCFException("MongoDB: Given database username and password doesn't match for the database given.");
                        }
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("MongoDB: Username = '" + MongodbOutputConnector.this.username + "'"));
                            Logging.connectors.debug((Object)"MongoDB: Password exists");
                        }
                    }
                }
                catch (Throwable e) {
                    this.exception = e;
                }
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

