/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class TrustsDescription {
    public static final String _rcsid = "@(#)$Id: TrustsDescription.java 988245 2010-08-23 18:39:35Z kwright $";
    protected HashMap patternHash = new HashMap();

    public TrustsDescription(ConfigParams configData) throws ManifoldCFException {
        int i = 0;
        while (i < configData.getChildCount()) {
            ConfigNode node;
            if (!(node = configData.getChild(i++)).getType().equals("trust")) continue;
            String urlDescription = node.getAttributeValue("urlregexp");
            String trustEverything = node.getAttributeValue("trusteverything");
            try {
                Pattern p;
                try {
                    p = Pattern.compile(urlDescription, 64);
                }
                catch (PatternSyntaxException e) {
                    throw new ManifoldCFException("Trust regular expression '" + urlDescription + "' is illegal: " + e.getMessage(), (Throwable)e);
                }
                if (trustEverything != null && trustEverything.equals("true")) {
                    TrustsItem ti = new TrustsItem(p, null);
                    this.patternHash.put(urlDescription, ti);
                    continue;
                }
                String trustStore = node.getAttributeValue("truststore");
                TrustsItem ti = new TrustsItem(p, trustStore);
                this.patternHash.put(urlDescription, ti);
            }
            catch (PatternSyntaxException e) {
                throw new ManifoldCFException("Bad pattern syntax in '" + urlDescription + "': " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public IKeystoreManager getTrustStore(String url) throws ManifoldCFException {
        IKeystoreManager rval = KeystoreManagerFactory.make((String)"");
        int certNumber = 0;
        for (String urlDescription : this.patternHash.keySet()) {
            TrustsItem ti = (TrustsItem)this.patternHash.get(urlDescription);
            Pattern p = ti.getPattern();
            Matcher m = p.matcher(url);
            if (!m.find()) continue;
            IKeystoreManager trustStore = ti.getTrustStore();
            if (trustStore == null) {
                return null;
            }
            String[] aliases = trustStore.getContents();
            int j = 0;
            while (j < aliases.length) {
                rval.addCertificate(Integer.toString(certNumber), trustStore.getCertificate(aliases[j++]));
                ++certNumber;
            }
        }
        return rval;
    }

    protected static class TrustsItem {
        protected Pattern pattern;
        protected IKeystoreManager trustStore;

        public TrustsItem(Pattern p, String trustStoreString) throws ManifoldCFException {
            this.pattern = p;
            this.trustStore = trustStoreString != null ? KeystoreManagerFactory.make((String)"", (String)trustStoreString) : null;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public IKeystoreManager getTrustStore() {
            return this.trustStore;
        }
    }
}

