/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.notifications.rocketchat;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.notifications.BaseNotificationConnector;
import org.apache.manifoldcf.crawler.notifications.rocketchat.Messages;
import org.apache.manifoldcf.crawler.notifications.rocketchat.RocketChatMessage;
import org.apache.manifoldcf.crawler.notifications.rocketchat.RocketChatSession;
import org.apache.manifoldcf.crawler.system.Logging;

public class RocketChatConnector
extends BaseNotificationConnector {
    protected static final long SESSION_EXPIRATION_MILLISECONDS = 300000L;
    protected long sessionExpiration = -1L;
    protected String serverUrl = null;
    protected String user;
    protected String password;
    protected RocketChatSession.ProxySettings proxySettings = null;
    protected RocketChatSession session = null;

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
        this.serverUrl = configParameters.getParameter("serverUrl");
        this.user = configParameters.getParameter("user");
        this.password = configParameters.getObfuscatedParameter("password");
        String proxyHost = configParameters.getParameter("proxyHost");
        String proxyPortString = configParameters.getParameter("proxyPort");
        if (StringUtils.isNotEmpty((String)proxyHost) && StringUtils.isNotEmpty((String)proxyPortString)) {
            String proxyUsername = configParameters.getParameter("proxyUsername");
            String proxyPassword = configParameters.getObfuscatedParameter("proxyPassword");
            String proxyDomain = configParameters.getParameter("proxyDomain");
            this.proxySettings = new RocketChatSession.ProxySettings(proxyHost, proxyPortString, proxyUsername, proxyPassword, proxyDomain);
        } else {
            Logging.connectors.info((Object)"Using no proxy settings - no proxyHost and no proxyPort found.");
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.serverUrl = null;
        this.user = null;
        this.password = null;
        this.proxySettings = null;
        this.finalizeConnection();
        super.disconnect();
    }

    public void poll() throws ManifoldCFException {
        if (this.session != null && System.currentTimeMillis() >= this.sessionExpiration) {
            this.finalizeConnection();
        }
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected void checkConnection() throws ManifoldCFException, ServiceInterruption {
        this.finalizeConnection();
        this.getSession();
        try {
            CheckConnectionThread cct = new CheckConnectionThread(this.session);
            cct.start();
            cct.finishUp();
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        catch (IOException e) {
            RocketChatConnector.handleIOException(e, "checking the connection");
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.session == null) {
            if (this.serverUrl == null) {
                throw new ManifoldCFException("Missing serverUrl parameter");
            }
            if (this.user == null) {
                throw new ManifoldCFException("Missing user parameter");
            }
            if (this.password == null) {
                throw new ManifoldCFException("Missing password parameter");
            }
            try {
                ConnectThread connectThread = new ConnectThread(this.serverUrl, this.user, this.password, this.proxySettings);
                connectThread.start();
                this.session = connectThread.finishUp();
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), 2);
            }
            catch (IOException e) {
                RocketChatConnector.handleIOException(e, "connecting");
            }
        }
        this.sessionExpiration = System.currentTimeMillis() + 300000L;
    }

    protected void finalizeConnection() {
        if (this.session != null) {
            try {
                CloseSessionThread closeSessionThread = new CloseSessionThread(this.session);
                closeSessionThread.start();
                closeSessionThread.finishUp();
            }
            catch (InterruptedException closeSessionThread) {
            }
            catch (IOException e) {
                Logging.connectors.warn((Object)("Error while closing connection to server: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.session = null;
            }
        }
    }

    public void notifyOfJobStopErrorAbort(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendRocketChatMessage(spec, "erroraborted");
    }

    public void notifyOfJobStopManualAbort(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendRocketChatMessage(spec, "manualaborted");
    }

    public void notifyOfJobStopManualPause(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendRocketChatMessage(spec, "manualpaused");
    }

    public void notifyOfJobStopSchedulePause(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendRocketChatMessage(spec, "schedulepaused");
    }

    public void notifyOfJobStopRestart(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendRocketChatMessage(spec, "restarted");
    }

    public void notifyOfJobEnd(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendRocketChatMessage(spec, "finished");
    }

    protected void sendRocketChatMessage(Specification spec, String nodeType) throws ManifoldCFException, ServiceInterruption {
        String defaultChannel = null;
        String alias = null;
        String emoji = null;
        String avatar = null;
        String channel = "";
        String message = "";
        if (nodeType != null) {
            for (int i = 0; i < spec.getChildCount(); ++i) {
                SpecificationNode sn;
                int j;
                SpecificationNode childNode = spec.getChild(i);
                if (childNode.getType().equals("globals")) {
                    for (j = 0; j < childNode.getChildCount(); ++j) {
                        sn = childNode.getChild(j);
                        if (sn.getType().equals("default_channel")) {
                            defaultChannel = sn.getAttributeValue("value");
                            continue;
                        }
                        if (sn.getType().equals("alias")) {
                            alias = sn.getAttributeValue("value");
                            continue;
                        }
                        if (sn.getType().equals("emoji")) {
                            emoji = sn.getAttributeValue("value");
                            continue;
                        }
                        if (!sn.getType().equals("avatar")) continue;
                        avatar = sn.getAttributeValue("value");
                    }
                    continue;
                }
                if (!childNode.getType().equals(nodeType)) continue;
                for (j = 0; j < childNode.getChildCount(); ++j) {
                    sn = childNode.getChild(j);
                    if (sn.getType().equals("channel")) {
                        channel = sn.getAttributeValue("value");
                        continue;
                    }
                    if (!sn.getType().equals("message")) continue;
                    message = sn.getAttributeValue("value");
                }
            }
        }
        if (StringUtils.isBlank((String)message)) {
            return;
        }
        if (StringUtils.isBlank((String)channel)) {
            if (StringUtils.isBlank(defaultChannel)) {
                return;
            }
            channel = defaultChannel;
        }
        this.getSession();
        RocketChatMessage chatMessage = new RocketChatMessage();
        chatMessage.setChannel(channel);
        chatMessage.setText(message);
        chatMessage.setAlias(alias);
        chatMessage.setEmoji(emoji);
        chatMessage.setAvatar(avatar);
        SendThread st = new SendThread(this.session, chatMessage);
        st.start();
        try {
            st.finishUp();
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        catch (IOException e) {
            RocketChatConnector.handleIOException(e, "sending rocketchat message");
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "RocketChatConnector.RestAPI"));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        RocketChatConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "ConfigurationHeader.js", paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        RocketChatConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "Configuration_Server.html", paramMap);
    }

    private static void fillInServerConfigurationMap(Map<String, Object> paramMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String serverUrl = RocketChatConnector.getEmptyOnNull(parameters, "serverUrl");
        String user = RocketChatConnector.getEmptyOnNull(parameters, "user");
        String password = parameters.getObfuscatedParameter("password");
        password = password == null ? "" : mapper.mapPasswordToKey(password);
        String proxyHost = RocketChatConnector.getEmptyOnNull(parameters, "proxyHost");
        String proxyPort = RocketChatConnector.getEmptyOnNull(parameters, "proxyPort");
        String proxyUsername = RocketChatConnector.getEmptyOnNull(parameters, "proxyUsername");
        String proxyPassword = parameters.getObfuscatedParameter("proxyPassword");
        proxyPassword = proxyPassword == null ? "" : mapper.mapPasswordToKey(proxyPassword);
        String proxyDomain = RocketChatConnector.getEmptyOnNull(parameters, "proxyDomain");
        paramMap.put("SERVER_URL", serverUrl);
        paramMap.put("USER", user);
        paramMap.put("PASSWORD", password);
        paramMap.put("PROXY_HOST", proxyHost);
        paramMap.put("PROXY_PORT", proxyPort);
        paramMap.put("PROXY_USERNAME", proxyUsername);
        paramMap.put("PROXY_PASSWORD", proxyPassword);
        paramMap.put("PROXY_DOMAIN", proxyDomain);
    }

    private static String getEmptyOnNull(ConfigParams parameters, String key) {
        String value = parameters.getParameter(key);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String proxyDomain;
        String proxyPassword;
        String proxyPort;
        String proxyHost;
        String password;
        String user;
        String serverUrl = variableContext.getParameter("serverUrl");
        if (serverUrl != null) {
            parameters.setParameter("serverUrl", serverUrl);
        }
        if ((user = variableContext.getParameter("user")) != null) {
            parameters.setParameter("user", user);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter("password", variableContext.mapKeyToPassword(password));
        }
        if ((proxyHost = variableContext.getParameter("proxyHost")) != null) {
            parameters.setParameter("proxyHost", proxyHost);
        }
        if (StringUtils.isNotEmpty((String)(proxyPort = variableContext.getParameter("proxyPort")))) {
            try {
                Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException e) {
                Logging.connectors.warn((Object)("Proxy port must be a number. Found " + proxyPort));
                throw new ManifoldCFException("Proxy Port must be a number: " + e.getMessage(), (Throwable)e);
            }
            parameters.setParameter("proxyPort", proxyPort);
        } else if (proxyPort != null) {
            parameters.setParameter("proxyPort", proxyPort);
        }
        String proxyUsername = variableContext.getParameter("proxyUsername");
        if (proxyUsername != null) {
            parameters.setParameter("proxyUsername", proxyUsername);
        }
        if ((proxyPassword = variableContext.getParameter("proxyPassword")) != null) {
            parameters.setObfuscatedParameter("proxyPassword", variableContext.mapKeyToPassword(proxyPassword));
        }
        if ((proxyDomain = variableContext.getParameter("proxyDomain")) != null) {
            parameters.setParameter("proxyDomain", proxyDomain);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        RocketChatConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "ConfigurationView.html", paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        tabsArray.add(Messages.getString(locale, "RocketChatConnector.Message"));
        Messages.outputResourceWithVelocity(out, locale, "SpecificationHeader.js", paramMap);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        this.outputMessageTab(out, locale, ds, tabName, connectionSequenceNumber, actualSequenceNumber);
    }

    protected void outputMessageTab(IHTTPOutput out, Locale locale, Specification ds, String tabName, int connectionSequenceNumber, int actualSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        paramMap.put("SelectedNum", Integer.toString(actualSequenceNumber));
        RocketChatConnector.fillInMessageTab(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, "Specification_Message.html", paramMap);
    }

    protected static void fillInMessageTab(Map<String, Object> paramMap, Specification ds) {
        SpecificationNode sn;
        int j;
        SpecificationNode childNode;
        int i;
        RocketChatConnector.addRecord(paramMap, "finished", "", "");
        RocketChatConnector.addRecord(paramMap, "erroraborted", "", "");
        RocketChatConnector.addRecord(paramMap, "manualaborted", "", "");
        RocketChatConnector.addRecord(paramMap, "manualpaused", "", "");
        RocketChatConnector.addRecord(paramMap, "schedulepaused", "", "");
        RocketChatConnector.addRecord(paramMap, "restarted", "", "");
        for (i = 0; i < ds.getChildCount(); ++i) {
            childNode = ds.getChild(i);
            if (!childNode.getType().equals("finished") && !childNode.getType().equals("erroraborted") && !childNode.getType().equals("manualaborted") && !childNode.getType().equals("manualpaused") && !childNode.getType().equals("schedulepaused") && !childNode.getType().equals("restarted")) continue;
            String channel = "";
            String message = "";
            for (j = 0; j < childNode.getChildCount(); ++j) {
                sn = childNode.getChild(j);
                if (sn.getType().equals("channel")) {
                    channel = sn.getAttributeValue("value");
                    continue;
                }
                if (!sn.getType().equals("message")) continue;
                message = sn.getAttributeValue("value");
            }
            RocketChatConnector.addRecord(paramMap, childNode.getType(), channel, message);
        }
        paramMap.put("default_channel", "");
        paramMap.put("alias", "");
        paramMap.put("emoji", "");
        paramMap.put("avatar", "");
        for (i = 0; i < ds.getChildCount(); ++i) {
            childNode = ds.getChild(i);
            if (!childNode.getType().equals("globals")) continue;
            for (j = 0; j < childNode.getChildCount(); ++j) {
                sn = childNode.getChild(j);
                if (sn.getType().equals("default_channel")) {
                    paramMap.put("default_channel", sn.getAttributeValue("value"));
                    continue;
                }
                if (sn.getType().equals("alias")) {
                    paramMap.put("alias", sn.getAttributeValue("value"));
                    continue;
                }
                if (sn.getType().equals("emoji")) {
                    paramMap.put("emoji", sn.getAttributeValue("value"));
                    continue;
                }
                if (!sn.getType().equals("avatar")) continue;
                paramMap.put("avatar", sn.getAttributeValue("value"));
            }
        }
    }

    protected static void addRecord(Map<String, Object> paramMap, String nodeType, String channel, String message) {
        paramMap.put(nodeType + "_CHANNEL", channel);
        paramMap.put(nodeType + "_MESSAGE", message);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        return this.processMessageTab(variableContext, ds, connectionSequenceNumber);
    }

    protected String processMessageTab(IPostParameters variableContext, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String avatar;
        String emoji;
        String alias;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        RocketChatConnector.gatherRecord(ds, seqPrefix, variableContext, "finished");
        RocketChatConnector.gatherRecord(ds, seqPrefix, variableContext, "erroraborted");
        RocketChatConnector.gatherRecord(ds, seqPrefix, variableContext, "manualaborted");
        RocketChatConnector.gatherRecord(ds, seqPrefix, variableContext, "manualpaused");
        RocketChatConnector.gatherRecord(ds, seqPrefix, variableContext, "schedulepaused");
        RocketChatConnector.gatherRecord(ds, seqPrefix, variableContext, "restarted");
        SpecificationNode sn = new SpecificationNode("globals");
        String defaultChannel = variableContext.getParameter("default_channel");
        if (defaultChannel != null) {
            RocketChatConnector.addNodeValue(sn, "default_channel", defaultChannel);
        }
        if ((alias = variableContext.getParameter("alias")) != null) {
            RocketChatConnector.addNodeValue(sn, "alias", alias);
        }
        if ((emoji = variableContext.getParameter("emoji")) != null) {
            RocketChatConnector.addNodeValue(sn, "emoji", emoji);
        }
        if ((avatar = variableContext.getParameter("avatar")) != null) {
            RocketChatConnector.addNodeValue(sn, "avatar", avatar);
        }
        ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
        return null;
    }

    protected static void gatherRecord(Specification ds, String seqPrefix, IPostParameters variableContext, String nodeType) {
        String message;
        RocketChatConnector.removeNodes(ds, nodeType);
        SpecificationNode sn = new SpecificationNode(nodeType);
        String channel = variableContext.getParameter(seqPrefix + nodeType + "_channel");
        if (channel != null) {
            RocketChatConnector.addNodeValue(sn, "channel", channel);
        }
        if ((message = variableContext.getParameter(seqPrefix + nodeType + "_message")) != null) {
            RocketChatConnector.addNodeValue(sn, "message", message);
        }
        ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        RocketChatConnector.fillInMessageTab(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, "SpecificationView.html", paramMap);
    }

    protected static void removeNodes(Specification ds, String nodeTypeName) {
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn = ds.getChild(i);
            if (sn.getType().equals(nodeTypeName)) {
                ds.removeChild(i);
                continue;
            }
            ++i;
        }
    }

    protected static void addNodeValue(SpecificationNode ds, String nodeType, String value) {
        SpecificationNode sn = new SpecificationNode(nodeType);
        sn.setAttribute("value", value);
        ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
    }

    protected static void handleIOException(IOException e, String context) throws ManifoldCFException, ServiceInterruption {
        Logging.connectors.error((Object)("RocketChat: Error " + context + ": " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException("Error " + context + ": " + e.getMessage(), (Throwable)e);
    }

    protected static class SendThread
    extends Thread {
        protected final RocketChatSession session;
        protected final RocketChatMessage message;
        protected Throwable exception = null;

        public SendThread(RocketChatSession session, RocketChatMessage message) {
            this.session = session;
            this.message = message;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.send(this.message);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws IOException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class CheckConnectionThread
    extends Thread {
        protected final RocketChatSession session;
        protected Throwable exception = null;

        public CheckConnectionThread(RocketChatSession session) {
            this.session = session;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.checkConnection();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws IOException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class CloseSessionThread
    extends Thread {
        protected final RocketChatSession session;
        protected Throwable exception = null;

        public CloseSessionThread(RocketChatSession session) {
            this.session = session;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.close();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws IOException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class ConnectThread
    extends Thread {
        protected final String serverUrl;
        protected final String user;
        protected final String password;
        protected final RocketChatSession.ProxySettings proxySettings;
        protected RocketChatSession session = null;
        protected Throwable exception = null;

        public ConnectThread(String serverUrl, String user, String password, RocketChatSession.ProxySettings proxySettings) {
            this.serverUrl = serverUrl;
            this.user = user;
            this.password = password;
            this.proxySettings = proxySettings;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session = new RocketChatSession(this.serverUrl, this.user, this.password, this.proxySettings);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public RocketChatSession finishUp() throws IOException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
                return this.session;
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }
}

