/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.endpoints;

import java.util.LinkedHashMap;
import org.apache.chemistry.opencmis.commons.endpoints.CmisAuthentication;
import org.apache.chemistry.opencmis.commons.endpoints.CmisEndpoint;

public class CmisAuthenticationImpl
extends LinkedHashMap<String, Object>
implements CmisAuthentication {
    private static final long serialVersionUID = 1L;
    private CmisEndpoint endpoint;

    public CmisAuthenticationImpl(CmisEndpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoitn must be set!");
        }
        this.endpoint = endpoint;
    }

    public CmisAuthenticationImpl(CmisEndpoint endpoint, String type) {
        this(endpoint);
        this.put("type", type);
    }

    public String getType() {
        return this.getString("type");
    }

    public String getDisplayName() {
        return this.getString("displayName");
    }

    public String getDocumentationUrl() {
        return this.getString("documentationUrl");
    }

    public Integer getPreference() {
        Object value = this.get("preference");
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    public CmisEndpoint getEndpoint() {
        return this.endpoint;
    }

    public boolean requiresCookies() {
        if ("required".equals(this.endpoint.getCookies())) {
            return true;
        }
        String type = this.getType();
        if ("form".equals(type) || "saml".equals(type) || "ltpa".equals(type)) {
            return true;
        }
        return this.endpoint.getCsrfHeader() != null || this.endpoint.getCsrfParameter() == null;
    }

    protected String getString(String key) {
        Object value = this.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }
}

