/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractMultiParameterFunction;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

abstract class CatchAllMultiParameterFunction
extends AbstractMultiParameterFunction {
    CatchAllMultiParameterFunction() {
    }

    @Override
    public Expression evaluate(List<Expression> parameters, ProblemsHandler problemsHandler, FunctionExpression call, Expression evaluatedParameter) {
        if (this.getMinParameters() == this.getMaxParameters() && parameters.size() != this.getMinParameters()) {
            problemsHandler.wrongNumberOfArgumentsToFunction(call, this.getName(), this.getMinParameters());
            return new FaultyExpression(call);
        }
        if (parameters.size() < this.getMinParameters()) {
            problemsHandler.wrongNumberOfArgumentsToFunctionMin(call, this.getName(), this.getMinParameters());
            return new FaultyExpression(call);
        }
        if (parameters.size() > this.getMaxParameters()) {
            problemsHandler.wrongNumberOfArgumentsToFunctionMax(call, this.getName(), this.getMaxParameters());
            return new FaultyExpression(call);
        }
        for (int i = 0; i < parameters.size(); ++i) {
            if (this.validateParameter(parameters.get(i), i, problemsHandler)) continue;
            return new FaultyExpression(call);
        }
        return this.evaluate(parameters, problemsHandler, call, call.getUnderlyingStructure());
    }

    protected abstract Expression evaluate(List<Expression> var1, ProblemsHandler var2, FunctionExpression var3, HiddenTokenAwareTree var4);
}

