/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.autodetect;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.autodetect.FontFinder;
import org.apache.fop.fonts.autodetect.MacFontDirFinder;
import org.apache.fop.fonts.autodetect.UnixFontDirFinder;
import org.apache.fop.fonts.autodetect.WindowsFontDirFinder;

public class FontFileFinder
extends DirectoryWalker
implements FontFinder {
    private final Log log = LogFactory.getLog((Class)FontFileFinder.class);
    public static final int DEFAULT_DEPTH_LIMIT = -1;

    public FontFileFinder() {
        super(FontFileFinder.getDirectoryFilter(), FontFileFinder.getFileFilter(), -1);
    }

    public FontFileFinder(int depthLimit) {
        super(FontFileFinder.getDirectoryFilter(), FontFileFinder.getFileFilter(), depthLimit);
    }

    protected static IOFileFilter getDirectoryFilter() {
        return FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)".")));
    }

    protected static IOFileFilter getFileFilter() {
        return FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)new WildcardFileFilter(new String[]{"*.ttf", "*.otf", "*.pfb", "*.ttc"}, IOCase.INSENSITIVE));
    }

    protected boolean handleDirectory(File directory, int depth, Collection results) {
        return true;
    }

    protected void handleFile(File file, int depth, Collection results) {
        try {
            results.add(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            this.log.debug((Object)("MalformedURLException" + e.getMessage()));
        }
    }

    protected void handleDirectoryEnd(File directory, int depth, Collection results) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(directory + ": found " + results.size() + " font" + (results.size() == 1 ? "" : "s")));
        }
    }

    public List find() throws IOException {
        String osName = System.getProperty("os.name");
        FontFinder fontDirFinder = osName.startsWith("Windows") ? new WindowsFontDirFinder() : (osName.startsWith("Mac") ? new MacFontDirFinder() : new UnixFontDirFinder());
        List fontDirs = fontDirFinder.find();
        ArrayList results = new ArrayList();
        Iterator iter = fontDirs.iterator();
        while (iter.hasNext()) {
            File dir = (File)iter.next();
            super.walk(dir, results);
        }
        return results;
    }

    public List find(String dir) throws IOException {
        ArrayList results = new ArrayList();
        super.walk(new File(dir), results);
        return results;
    }
}

