/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.DateTimeFormat;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.AbstractBrowserServiceCall;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserCallContextImpl;
import org.apache.chemistry.opencmis.server.impl.browser.ServerTypeCacheImpl;

public class RelationshipService {

    public static class GetObjectRelationships
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            Boolean includeSubRelationshipTypes = this.getBooleanParameter(request, "includeSubRelationshipTypes");
            RelationshipDirection relationshipDirection = this.getEnumParameter(request, "relationshipDirection", RelationshipDirection.class);
            String typeId = this.getStringParameter(request, "typeId");
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            BigInteger maxItems = this.getBigIntegerParameter(request, "maxItems");
            BigInteger skipCount = this.getBigIntegerParameter(request, "skipCount");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            ObjectList relationships = service.getObjectRelationships(repositoryId, objectId, includeSubRelationshipTypes, relationshipDirection, typeId, renditionFilter, includeAllowableActions, maxItems, skipCount, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (relationships == null) {
                throw new CmisRuntimeException("Relationships are null!");
            }
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonChildren = JSONConverter.convert((ObjectList)relationships, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonChildren, request, response);
        }
    }
}

