/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.validator;

import java.util.regex.PatternSyntaxException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.commons.util.MessageUtils;
import org.apache.myfaces.commons.validator.ValidatorBase;

public abstract class AbstractCSVValidator
extends ValidatorBase {
    public static final String VALIDATOR_ID = "org.apache.myfaces.commons.validator.csv";
    public static final String CSV_NOT_STRING_MESSAGE_ID = "org.apache.myfaces.commons.validator.csv.NOT_STRING";
    public static final String CSV_INVALID_SEPARATOR_MESSAGE_ID = "org.apache.myfaces.commons.validator.csv.INVALID_SEPARATOR";
    public static final String CSV_SUFFIX_MESSAGE_ID = "org.apache.myfaces.commons.validator.csv.SUFFIX";
    private static final String DEFAULT_SEPARATOR = ",";

    public abstract String getSubvalidatorId();

    public abstract void setSubvalidatorId(String var1);

    public abstract String getSeparator();

    public abstract void setSeparator(String var1);

    private FacesMessage addMessage(FacesMessage oldMsg, FacesMessage newMsg, int index, String suffixMessageKey) {
        if (oldMsg != null && newMsg.getSeverity().getOrdinal() < oldMsg.getSeverity().getOrdinal()) {
            return oldMsg;
        }
        String summaryMessageText = null;
        String detailMessageText = null;
        if (oldMsg == null || newMsg.getSeverity().getOrdinal() > oldMsg.getSeverity().getOrdinal()) {
            summaryMessageText = null;
            detailMessageText = null;
        } else {
            summaryMessageText = oldMsg.getSummary();
            detailMessageText = oldMsg.getDetail();
        }
        Object[] args = new Object[]{index + 1};
        FacesMessage suffixMessage = MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)suffixMessageKey, (Object[])args);
        String summarySuffix = suffixMessage.getSummary();
        String detailSuffix = suffixMessage.getDetail();
        if (summarySuffix == null) {
            summarySuffix = detailSuffix;
        } else if (detailSuffix == null) {
            detailSuffix = summarySuffix;
        }
        String summary = newMsg.getSummary();
        summaryMessageText = summaryMessageText == null ? summary + summarySuffix : summaryMessageText + ", " + summary + summarySuffix;
        String detail = newMsg.getDetail();
        detailMessageText = detailMessageText == null ? detail + detailSuffix : detailMessageText + ", " + detail + detailSuffix;
        return new FacesMessage(newMsg.getSeverity(), summaryMessageText, detailMessageText);
    }

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return;
        }
        String suffixMessageKey = this.getMessage();
        if (suffixMessageKey == null) {
            suffixMessageKey = CSV_SUFFIX_MESSAGE_ID;
        }
        FacesMessage facesMsg = null;
        if (!(value instanceof String)) {
            Object[] args = new Object[]{value};
            throw new ValidatorException(MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)CSV_NOT_STRING_MESSAGE_ID, (Object[])args));
        }
        Validator validator = facesContext.getApplication().createValidator(this.getSubvalidatorId());
        if (this.getSeparator() == null) {
            this.setSeparator(DEFAULT_SEPARATOR);
        }
        String[] values = null;
        try {
            values = ((String)value).split(this.getSeparator());
        }
        catch (PatternSyntaxException e) {
            Object[] args = new Object[]{this.getSeparator()};
            throw new ValidatorException(MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)CSV_INVALID_SEPARATOR_MESSAGE_ID, (Object[])args));
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i].trim().length() == 0) continue;
            try {
                validator.validate(facesContext, uiComponent, (Object)values[i]);
                continue;
            }
            catch (ValidatorException e) {
                facesMsg = this.addMessage(facesMsg, e.getFacesMessage(), i, suffixMessageKey);
            }
        }
        if (facesMsg != null) {
            throw new ValidatorException(facesMsg);
        }
    }
}

