/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.component._ValueBindingToValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIComponent
implements StateHolder {
    protected Map<String, ValueExpression> bindings;

    public abstract Map<String, Object> getAttributes();

    public abstract ValueBinding getValueBinding(String var1);

    public ValueExpression getValueExpression(String name) {
        if (name == null) {
            throw new NullPointerException("name can not be null");
        }
        if (this.bindings == null) {
            ValueBinding vb;
            if (!(this instanceof UIComponentBase) && (vb = this.getValueBinding(name)) != null) {
                this.bindings = new HashMap<String, ValueExpression>();
                _ValueBindingToValueExpression ve = new _ValueBindingToValueExpression(vb);
                this.bindings.put(name, ve);
                return ve;
            }
        } else {
            return this.bindings.get(name);
        }
        return null;
    }

    public abstract void setValueBinding(String var1, ValueBinding var2);

    public void setValueExpression(String name, ValueExpression expression) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("id")) {
            throw new IllegalArgumentException("Can't set a ValueExpression for the 'id' property.");
        }
        if (name.equals("parent")) {
            throw new IllegalArgumentException("Can't set a ValueExpression for the 'parent' property.");
        }
        if (expression == null) {
            if (this.bindings != null) {
                this.bindings.remove(name);
                if (this.bindings.isEmpty()) {
                    this.bindings = null;
                }
            }
        } else {
            if (expression.isLiteralText()) {
                try {
                    Object value = expression.getValue(this.getFacesContext().getELContext());
                    this.getAttributes().put(name, value);
                    return;
                }
                catch (ELException e) {
                    throw new FacesException(e);
                }
            }
            if (this.bindings == null) {
                this.bindings = new HashMap<String, ValueExpression>();
            }
            this.bindings.put(name, expression);
        }
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (context == null || clientId == null || callback == null) {
            throw new NullPointerException();
        }
        boolean found = clientId.equals(this.getClientId(context));
        if (found) {
            try {
                callback.invokeContextCallback(context, this);
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
            return found;
        }
        Iterator<UIComponent> it = this.getFacetsAndChildren();
        while (!found && it.hasNext()) {
            found = it.next().invokeOnComponent(context, clientId, callback);
        }
        return found;
    }

    public abstract String getClientId(FacesContext var1);

    public abstract String getFamily();

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract UIComponent getParent();

    public abstract void setParent(UIComponent var1);

    public abstract boolean isRendered();

    public abstract void setRendered(boolean var1);

    public abstract String getRendererType();

    public abstract void setRendererType(String var1);

    public abstract boolean getRendersChildren();

    public abstract List<UIComponent> getChildren();

    public abstract int getChildCount();

    public abstract UIComponent findComponent(String var1);

    public abstract Map<String, UIComponent> getFacets();

    public abstract UIComponent getFacet(String var1);

    public abstract Iterator<UIComponent> getFacetsAndChildren();

    public abstract void broadcast(FacesEvent var1) throws AbortProcessingException;

    public abstract void decode(FacesContext var1);

    public abstract void encodeBegin(FacesContext var1) throws IOException;

    public abstract void encodeChildren(FacesContext var1) throws IOException;

    public abstract void encodeEnd(FacesContext var1) throws IOException;

    public void encodeAll(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isRendered()) {
            this.encodeBegin(context);
            if (this.getRendersChildren()) {
                this.encodeChildren(context);
            } else if (this.getChildCount() > 0) {
                for (UIComponent comp : this.getChildren()) {
                    comp.encodeAll(context);
                }
            }
            this.encodeEnd(context);
        }
    }

    protected abstract void addFacesListener(FacesListener var1);

    protected abstract FacesListener[] getFacesListeners(Class var1);

    protected abstract void removeFacesListener(FacesListener var1);

    public abstract void queueEvent(FacesEvent var1);

    public abstract void processRestoreState(FacesContext var1, Object var2);

    public abstract void processDecodes(FacesContext var1);

    public abstract void processValidators(FacesContext var1);

    public abstract void processUpdates(FacesContext var1);

    public abstract Object processSaveState(FacesContext var1);

    protected abstract FacesContext getFacesContext();

    protected abstract Renderer getRenderer(FacesContext var1);

    public int getFacetCount() {
        Map<String, UIComponent> facets = this.getFacets();
        return facets == null ? 0 : facets.size();
    }

    public String getContainerClientId(FacesContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("FacesContext ctx");
        }
        return this.getClientId(ctx);
    }
}

