/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator._ParametrizableFacesMessage;

class _MessageUtils {
    private static final String DETAIL_SUFFIX = "_detail";

    _MessageUtils() {
    }

    static FacesMessage getErrorMessage(FacesContext facesContext, String messageId, Object[] args) {
        return _MessageUtils.getMessage(facesContext, facesContext.getViewRoot().getLocale(), FacesMessage.SEVERITY_ERROR, messageId, args);
    }

    static FacesMessage getMessage(FacesContext facesContext, Locale locale, FacesMessage.Severity severity, String messageId, Object[] args) {
        String detail;
        ResourceBundle appBundle;
        String summary;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((summary = _MessageUtils.getBundleString(appBundle = _MessageUtils.getApplicationBundle(facesContext, locale), messageId)) != null) {
            detail = _MessageUtils.getBundleString(appBundle, messageId + DETAIL_SUFFIX);
        } else {
            ResourceBundle defBundle = _MessageUtils.getDefaultBundle(facesContext, locale);
            summary = _MessageUtils.getBundleString(defBundle, messageId);
            if (summary != null) {
                detail = _MessageUtils.getBundleString(defBundle, messageId + DETAIL_SUFFIX);
            } else {
                detail = _MessageUtils.getBundleString(appBundle, messageId + DETAIL_SUFFIX);
                if (detail != null) {
                    summary = null;
                } else {
                    detail = _MessageUtils.getBundleString(defBundle, messageId + DETAIL_SUFFIX);
                    if (detail != null) {
                        summary = null;
                    } else {
                        facesContext.getExternalContext().log("No message with id " + messageId + " found in any bundle");
                        return new FacesMessage(severity, messageId, null);
                    }
                }
            }
        }
        if (args != null && args.length > 0) {
            return new _ParametrizableFacesMessage(severity, summary, detail, args, locale);
        }
        return new FacesMessage(severity, summary, detail);
    }

    private static String getBundleString(ResourceBundle bundle, String key) {
        try {
            return bundle == null ? null : bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static ResourceBundle getApplicationBundle(FacesContext facesContext, Locale locale) {
        String bundleName = facesContext.getApplication().getMessageBundle();
        return bundleName != null ? _MessageUtils.getBundle(facesContext, locale, bundleName) : null;
    }

    private static ResourceBundle getDefaultBundle(FacesContext facesContext, Locale locale) {
        return _MessageUtils.getBundle(facesContext, locale, "javax.faces.Messages");
    }

    private static ResourceBundle getBundle(FacesContext facesContext, Locale locale, String bundleName) {
        try {
            return ResourceBundle.getBundle(bundleName, locale, facesContext.getClass().getClassLoader());
        }
        catch (MissingResourceException ignore1) {
            try {
                return ResourceBundle.getBundle(bundleName, locale, _MessageUtils.class.getClassLoader());
            }
            catch (MissingResourceException ignore2) {
                try {
                    return ResourceBundle.getBundle(bundleName, locale, Thread.currentThread().getContextClassLoader());
                }
                catch (MissingResourceException damned) {
                    facesContext.getExternalContext().log("resource bundle " + bundleName + " could not be found");
                    return null;
                }
            }
        }
    }

    static Object getLabel(FacesContext facesContext, UIComponent component) {
        Object label = component.getAttributes().get("label");
        if (label != null) {
            return label;
        }
        ValueExpression expression = component.getValueExpression("label");
        if (expression != null) {
            return expression;
        }
        return component.getClientId(facesContext);
    }
}

