/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import java.beans.BeanDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.view.AttachedObjectTarget;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;
import org.apache.myfaces.view.facelets.tag.composite.InterfaceDescriptorCreator;

public abstract class AttachedObjectTargetHandler<T extends AttachedObjectTarget>
extends TagHandler
implements InterfaceDescriptorCreator {
    private static final Logger log = Logger.getLogger(AttachedObjectTargetHandler.class.getName());
    protected final TagAttribute _name = this.getRequiredAttribute("name");
    protected final TagAttribute _targets = this.getAttribute("targets");
    private boolean _cacheable = this._name.isLiteral();
    private AttachedObjectTarget _target;

    public AttachedObjectTargetHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        UIComponent compositeBaseParent = FaceletCompositionContext.getCurrentInstance(ctx).getCompositeComponentFromStack();
        CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)compositeBaseParent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        if (beanInfo == null) {
            if (log.isLoggable(Level.SEVERE)) {
                log.severe("Cannot find composite bean descriptor UIComponent.BEANINFO_KEY ");
            }
            return;
        }
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        ArrayList<Object> targetList = (ArrayList<Object>)beanDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
        if (targetList == null) {
            targetList = new ArrayList<Object>(5);
            beanDescriptor.setValue("javax.faces.view.AttachedObjectTargets", targetList);
        }
        if (this.isCacheable()) {
            if (this._target == null) {
                this._target = this.createAttachedObjectTarget(ctx);
            }
            targetList.add(this._target);
        } else {
            T target = this.createAttachedObjectTarget(ctx);
            targetList.add(target);
        }
        this.nextHandler.apply(ctx, parent);
    }

    @Override
    public boolean isCacheable() {
        return this._cacheable;
    }

    @Override
    public void setCacheable(boolean cacheable) {
        this._cacheable = cacheable;
    }

    protected abstract T createAttachedObjectTarget(FaceletContext var1);
}

