/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.search;

import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchKeywordContext;
import javax.faces.component.search.SearchKeywordResolver;
import javax.faces.component.search.UntargetableComponent;

public class NextSearchKeywordResolver
extends SearchKeywordResolver {
    public static final String NEXT_KEYWORD = "next";

    public void resolve(SearchKeywordContext expressionContext, UIComponent current, String keyword) {
        List children;
        int index;
        UIComponent parent = current.getParent();
        if (parent.getChildCount() > 1 && (index = (children = parent.getChildren()).indexOf(current)) < parent.getChildCount() - 1) {
            int nextIndex = -1;
            do {
                if (children.get(++index) instanceof UntargetableComponent) continue;
                nextIndex = index;
            } while (nextIndex == -1 && index < parent.getChildCount() - 1);
            if (nextIndex != -1) {
                expressionContext.invokeContextCallback((UIComponent)children.get(nextIndex));
            }
        }
        expressionContext.setKeywordResolved(true);
    }

    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        return NEXT_KEYWORD.equalsIgnoreCase(keyword);
    }

    public boolean isPassthrough(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }

    public boolean isLeaf(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }
}

