/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.search;

import javax.faces.component.UIComponent;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchKeywordContext;
import javax.faces.component.search.SearchKeywordResolver;

public class CompositeSearchKeywordResolver
extends SearchKeywordResolver {
    private int size = 0;
    private SearchKeywordResolver[] resolvers = new SearchKeywordResolver[2];

    public void add(SearchKeywordResolver elResolver) {
        if (elResolver == null) {
            throw new NullPointerException();
        }
        if (this.size >= this.resolvers.length) {
            SearchKeywordResolver[] nr = new SearchKeywordResolver[this.size * 2];
            System.arraycopy(this.resolvers, 0, nr, 0, this.size);
            this.resolvers = nr;
        }
        this.resolvers[this.size++] = elResolver;
    }

    @Override
    public void resolve(SearchKeywordContext context, UIComponent current, String keyword) {
        context.setKeywordResolved(false);
        int sz = this.size;
        for (int i = 0; i < sz; ++i) {
            if (!this.resolvers[i].isResolverForKeyword(context.getSearchExpressionContext(), keyword)) continue;
            this.resolvers[i].resolve(context, current, keyword);
            if (!context.isKeywordResolved()) continue;
            return;
        }
    }

    @Override
    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        int sz = this.size;
        for (int i = 0; i < sz; ++i) {
            if (!this.resolvers[i].isResolverForKeyword(searchExpressionContext, keyword)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPassthrough(SearchExpressionContext searchExpressionContext, String keyword) {
        int sz = this.size;
        for (int i = 0; i < sz; ++i) {
            if (!this.resolvers[i].isResolverForKeyword(searchExpressionContext, keyword)) continue;
            return this.resolvers[i].isPassthrough(searchExpressionContext, keyword);
        }
        return false;
    }

    @Override
    public boolean isLeaf(SearchExpressionContext searchExpressionContext, String keyword) {
        int sz = this.size;
        for (int i = 0; i < sz; ++i) {
            if (!this.resolvers[i].isResolverForKeyword(searchExpressionContext, keyword)) continue;
            return this.resolvers[i].isLeaf(searchExpressionContext, keyword);
        }
        return false;
    }
}

