/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.behavior;

import jakarta.faces.FacesWrapper;
import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.behavior.ClientBehaviorHint;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.BehaviorEvent;
import java.util.Set;
import org.apache.myfaces.cdi.behavior.FacesBehaviorAnnotationLiteral;
import org.apache.myfaces.cdi.util.CDIUtils;

public class FacesClientBehaviorCDIWrapper
implements PartialStateHolder,
ClientBehavior,
FacesWrapper<ClientBehavior> {
    private transient ClientBehavior delegate;
    private String behaviorId;
    private boolean _transient;
    private boolean _initialStateMarked = false;

    public FacesClientBehaviorCDIWrapper() {
    }

    public FacesClientBehaviorCDIWrapper(Class<? extends ClientBehavior> behaviorClass, String behaviorId) {
        this.behaviorId = behaviorId;
    }

    @Override
    public void broadcast(BehaviorEvent event) {
        this.getWrapped().broadcast(event);
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        this.getWrapped().decode(context, component);
    }

    @Override
    public Set<ClientBehaviorHint> getHints() {
        return this.getWrapped().getHints();
    }

    @Override
    public String getScript(ClientBehaviorContext behaviorContext) {
        return this.getWrapped().getScript(behaviorContext);
    }

    @Override
    public ClientBehavior getWrapped() {
        if (this.delegate == null) {
            this.delegate = CDIUtils.getInstance(CDIUtils.getBeanManager(FacesContext.getCurrentInstance().getExternalContext()), ClientBehavior.class, true, new FacesBehaviorAnnotationLiteral(this.behaviorId, true));
        }
        return this.delegate;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.behaviorId};
            return values;
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            Object[] values = (Object[])state;
            this.behaviorId = (String)values[0];
        }
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }
}

