/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit;

import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RenderKitFactoryImpl
extends RenderKitFactory {
    private static final Logger log = Logger.getLogger(RenderKitFactoryImpl.class.getName());
    private Map<String, RenderKit> _renderkits = new HashMap<String, RenderKit>();

    public void purgeRenderKit() {
        this._renderkits.clear();
    }

    @Override
    public void addRenderKit(String renderKitId, RenderKit renderKit) {
        if (renderKitId == null) {
            throw new NullPointerException("renderKitId");
        }
        if (renderKit == null) {
            throw new NullPointerException("renderKit");
        }
        if (log.isLoggable(Level.INFO) && this._renderkits.containsKey(renderKitId)) {
            log.info("RenderKit with renderKitId '" + renderKitId + "' was replaced.");
        }
        this._renderkits.put(renderKitId, renderKit);
    }

    @Override
    public RenderKit getRenderKit(FacesContext context, String renderKitId) throws FacesException {
        if (renderKitId == null) {
            throw new NullPointerException("renderKitId");
        }
        RenderKit renderkit = this._renderkits.get(renderKitId);
        if (renderkit == null) {
            log.warning("Unknown RenderKit '" + renderKitId + "'.");
        }
        return renderkit;
    }

    @Override
    public Iterator<String> getRenderKitIds() {
        return this._renderkits.keySet().iterator();
    }
}

