/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import jakarta.faces.FacesWrapper;
import jakarta.faces.application.Resource;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.PartialViewContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.resource.ContractResource;

public class ResourceUtils {
    public static final String MYFACES_LIBRARY_NAME = "org.apache.myfaces";
    public static final String JSF_MYFACES_JSFJS_MINIMAL = "minimal";
    public static final String JSF_MYFACES_JSFJS_NORMAL = "normal";
    public static final String FACES_UNCOMPRESSED_JS_RESOURCE_NAME = "faces-uncompressed.js";
    public static final String FACES_UNCOMPRESSED_FULL_JS_RESOURCE_NAME = "faces-uncompressed-full.js";
    public static final String FACES_MINIMAL_JS_RESOURCE_NAME = "faces-minimal.js";
    public static final String FACES_MYFACES_JSFJS_I18N = "faces-i18n.js";
    private static final String RENDERED_FACES_JS = "org.apache.myfaces.RENDERED_FACES_JS";
    public static final String JAKARTA_FACES_OUTPUT_COMPONENT_TYPE = "jakarta.faces.Output";
    public static final String JAKARTA_FACES_TEXT_RENDERER_TYPE = "jakarta.faces.Text";
    public static final String DEFAULT_SCRIPT_RENDERER_TYPE = "jakarta.faces.resource.Script";
    public static final String DEFAULT_STYLESHEET_RENDERER_TYPE = "jakarta.faces.resource.Stylesheet";

    public static void markScriptAsRendered(FacesContext facesContext, String libraryName, String resourceName) {
        facesContext.getApplication().getResourceHandler().markResourceRendered(facesContext, resourceName, libraryName);
    }

    public static void markStylesheetAsRendered(FacesContext facesContext, String libraryName, String resourceName) {
        facesContext.getApplication().getResourceHandler().markResourceRendered(facesContext, resourceName, libraryName);
    }

    public static boolean isRenderedScript(FacesContext facesContext, String libraryName, String resourceName) {
        return facesContext.getApplication().getResourceHandler().isResourceRendered(facesContext, resourceName, libraryName);
    }

    public static boolean isRenderedStylesheet(FacesContext facesContext, String libraryName, String resourceName) {
        return facesContext.getApplication().getResourceHandler().isResourceRendered(facesContext, resourceName, libraryName);
    }

    public static void writeScriptInline(FacesContext facesContext, ResponseWriter writer, String libraryName, String resourceName) throws IOException {
        if (!ResourceUtils.isRenderedScript(facesContext, libraryName, resourceName)) {
            Resource resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, libraryName);
            ResourceUtils.markScriptAsRendered(facesContext, libraryName, resourceName);
            writer.startElement("script", null);
            HtmlRendererUtils.renderScriptType(facesContext, writer);
            writer.writeURIAttribute("src", (Object)resource.getRequestPath(), null);
            writer.endElement("script");
        }
    }

    public static void renderDefaultJsfJsInlineIfNecessary(FacesContext facesContext, ResponseWriter writer) throws IOException {
        if (facesContext.getAttributes().containsKey(RENDERED_FACES_JS)) {
            return;
        }
        if (ResourceUtils.isRenderedScript(facesContext, "jakarta.faces", "faces.js")) {
            facesContext.getAttributes().put(RENDERED_FACES_JS, Boolean.TRUE);
            return;
        }
        PartialViewContext partialViewContext = facesContext.getPartialViewContext();
        if (partialViewContext != null && (partialViewContext.isPartialRequest() || partialViewContext.isAjaxRequest())) {
            return;
        }
        Resource resource = facesContext.getApplication().getResourceHandler().createResource("faces.js", "jakarta.faces");
        ResourceUtils.markScriptAsRendered(facesContext, "jakarta.faces", "faces.js");
        writer.startElement("script", null);
        HtmlRendererUtils.renderScriptType(facesContext, writer);
        writer.writeURIAttribute("src", (Object)resource.getRequestPath(), null);
        writer.endElement("script");
        facesContext.getAttributes().put(RENDERED_FACES_JS, Boolean.TRUE);
    }

    public static String getContractName(Resource resource) {
        while (resource != null) {
            if (resource instanceof ContractResource) {
                return ((ContractResource)resource).getContractName();
            }
            if (resource instanceof FacesWrapper) {
                resource = (Resource)((FacesWrapper)resource).getWrapped();
                continue;
            }
            resource = null;
        }
        return null;
    }
}

