/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.MetadataTarget;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.myfaces.core.api.shared.lang.LambdaPropertyDescriptor;
import org.apache.myfaces.core.api.shared.lang.PropertyDescriptorUtils;
import org.apache.myfaces.core.api.shared.lang.PropertyDescriptorWrapper;

public class LambdaMetadataTargetImpl
extends MetadataTarget {
    private final Map<String, ? extends PropertyDescriptorWrapper> propertyDescriptors;
    private final Class<?> type;

    public LambdaMetadataTargetImpl(Class<?> type) throws IntrospectionException {
        this.type = type;
        this.propertyDescriptors = PropertyDescriptorUtils.getCachedPropertyDescriptors(FacesContext.getCurrentInstance().getExternalContext(), type);
    }

    @Override
    public PropertyDescriptor getProperty(String name) {
        LambdaPropertyDescriptor lpd = this.getLambdaProperty(name);
        if (lpd == null) {
            return null;
        }
        return lpd.getWrapped();
    }

    @Override
    public Class<?> getPropertyType(String name) {
        LambdaPropertyDescriptor lpd = this.getLambdaProperty(name);
        if (lpd == null) {
            return null;
        }
        return lpd.getPropertyType();
    }

    @Override
    public Method getReadMethod(String name) {
        LambdaPropertyDescriptor lpd = this.getLambdaProperty(name);
        if (lpd == null) {
            return null;
        }
        return lpd.getReadMethod();
    }

    @Override
    public Class<?> getTargetClass() {
        return this.type;
    }

    @Override
    public Method getWriteMethod(String name) {
        LambdaPropertyDescriptor lpd = this.getLambdaProperty(name);
        if (lpd == null) {
            return null;
        }
        return lpd.getWriteMethod();
    }

    @Override
    public boolean isTargetInstanceOf(Class type) {
        return type.isAssignableFrom(type);
    }

    public LambdaPropertyDescriptor getLambdaProperty(String name) {
        return (LambdaPropertyDescriptor)this.propertyDescriptors.get(name);
    }

    public Function<Object, Object> getReadFunction(String name) {
        LambdaPropertyDescriptor lpd = this.getLambdaProperty(name);
        if (lpd == null) {
            return null;
        }
        return lpd.getReadFunction();
    }

    public BiConsumer<Object, Object> getWriteFunction(String name) {
        LambdaPropertyDescriptor lpd = this.getLambdaProperty(name);
        if (lpd == null) {
            return null;
        }
        return lpd.getWriteFunction();
    }
}

