/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.event;

import jakarta.inject.Qualifier;
import jakarta.websocket.CloseReason;
import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;

public final class WebsocketEvent
implements Serializable {
    private String channel;
    private Serializable user;
    private CloseReason.CloseCode code;

    public WebsocketEvent(String channel, Serializable user, CloseReason.CloseCode code) {
        this.channel = channel;
        this.user = user;
        this.code = code;
    }

    public String getChannel() {
        return this.channel;
    }

    public <S extends Serializable> S getUser() {
        return (S)this.user;
    }

    public CloseReason.CloseCode getCloseCode() {
        return this.code;
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + Objects.hashCode(this.channel);
        hash = 23 * hash + Objects.hashCode(this.user);
        hash = 23 * hash + Objects.hashCode(this.code);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebsocketEvent other = (WebsocketEvent)obj;
        if (!Objects.equals(this.channel, other.channel)) {
            return false;
        }
        if (!Objects.equals(this.user, other.user)) {
            return false;
        }
        return Objects.equals(this.code, other.code);
    }

    public String toString() {
        return "WebsocketEvent{channel=" + this.channel + ", user=" + this.user + ", code=" + this.code + "}";
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Closed {
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Opened {
    }
}

