/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.component.UISelectOne;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.CommonHtmlAttributesUtil;
import org.apache.myfaces.renderkit.html.util.CommonHtmlEventsUtil;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.SelectItemInfo;
import org.apache.myfaces.renderkit.html.util.SelectItemsUtils;

public class HtmlSelectableRendererBase
extends HtmlRenderer {
    protected void internalRenderSelect(FacesContext facesContext, UIComponent uiComponent, boolean disabled, int size, boolean selectMany, Converter converter) throws IOException {
        List<SelectItemInfo> selectItemList;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("select", uiComponent);
        if (uiComponent instanceof ClientBehaviorHolder && !((ClientBehaviorHolder)uiComponent).getClientBehaviors().isEmpty()) {
            writer.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), null);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        }
        writer.writeAttribute("name", (Object)uiComponent.getClientId(facesContext), null);
        if (selectMany) {
            writer.writeAttribute("multiple", (Object)"multiple", null);
            selectItemList = SelectItemsUtils.getSelectItemInfoList((UISelectMany)uiComponent, facesContext);
        } else {
            selectItemList = SelectItemsUtils.getSelectItemInfoList((UISelectOne)uiComponent, facesContext);
        }
        if (size == Integer.MIN_VALUE) {
            writer.writeAttribute("size", (Object)Integer.toString(selectItemList.size()), null);
        } else {
            writer.writeAttribute("size", (Object)Integer.toString(size), null);
        }
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors();
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                commonPropertiesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonHtmlAttributesUtil.renderChangeEventProperty(writer, commonPropertiesMarked, uiComponent);
                CommonHtmlAttributesUtil.renderEventProperties(writer, commonPropertiesMarked, uiComponent);
                CommonHtmlAttributesUtil.renderFieldEventPropertiesWithoutOnchangeAndOnselect(writer, commonPropertiesMarked, uiComponent);
            } else {
                HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, uiComponent, behaviors);
                if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonHtmlEventsUtil.getMarkedEvents(uiComponent);
                    CommonHtmlEventsUtil.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, behaviors);
                    CommonHtmlEventsUtil.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, uiComponent, behaviors);
                }
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonHtmlAttributesUtil.renderSelectPassthroughPropertiesWithoutDisabledAndEvents(writer, CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent), uiComponent);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
            }
        } else if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            CommonHtmlAttributesUtil.renderSelectPassthroughPropertiesWithoutDisabled(writer, CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent), uiComponent);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (HtmlRendererUtils.isReadOnly(uiComponent)) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet(selectMany, uiComponent, facesContext, converter);
        SelectItemsUtils.renderSelectOptions(facesContext, uiComponent, converter, lookupSet, selectItemList);
        writer.writeText((Object)"", null);
        writer.endElement("select");
    }
}

