/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.FacesException;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.html.HtmlForm;
import jakarta.faces.component.html.HtmlInputFile;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.ConverterException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonHtmlAttributesUtil;
import org.apache.myfaces.renderkit.html.util.CommonHtmlEventsUtil;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.HttpPartWrapper;

public class HtmlInputFileRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlInputFileRendererBase.class.getName());
    private static final String AUTOCOMPLETE_VALUE_OFF = "off";

    public void decode(FacesContext facesContext, UIComponent component) {
        try {
            String clientId = component.getClientId();
            HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
            Collection parts = request.getParts();
            ArrayList<HttpPartWrapper> submittedValues = new ArrayList<HttpPartWrapper>(parts.size());
            for (Part part : parts) {
                if (!clientId.equals(part.getName())) continue;
                HttpPartWrapper wrapper = new HttpPartWrapper(part);
                submittedValues.add(wrapper);
            }
            if (((HtmlInputFile)component).isMultiple()) {
                ((UIInput)component).setSubmittedValue(submittedValues);
            } else if (!submittedValues.isEmpty()) {
                ((UIInput)component).setSubmittedValue(submittedValues.iterator().next());
            }
        }
        catch (ServletException | IOException e) {
            throw new FacesException(e);
        }
        if (component instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(component)) {
            ClientBehaviorRendererUtils.decodeClientBehaviors(facesContext, component);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String content;
        UIForm form;
        this.renderInput(facesContext, component);
        if (!facesContext.isProjectStage(ProjectStage.Production) && facesContext.isPostback() && (facesContext.getPartialViewContext().isPartialRequest() || facesContext.getPartialViewContext().isAjaxRequest()) && (form = (UIForm)ComponentUtils.findClosest(UIForm.class, (UIComponent)component)) != null && form instanceof HtmlForm && ((content = ((HtmlForm)form).getEnctype()) == null || !content.contains("multipart/form-data"))) {
            FacesMessage message = new FacesMessage("file upload requires a form with enctype equal to multipart/form-data");
            facesContext.addMessage(component.getClientId(), message);
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Assert.notNull((Object)context, (String)"context");
        Assert.notNull((Object)component, (String)"component");
        if (submittedValue instanceof Part) {
            Part part2 = (Part)submittedValue;
            if (HtmlInputFileRendererBase.isEmpty(part2)) {
                return null;
            }
        } else if (submittedValue instanceof Collection) {
            Collection parts = (Collection)submittedValue;
            return Collections.unmodifiableList(parts.stream().filter(part -> !HtmlInputFileRendererBase.isEmpty(part)).collect(Collectors.toList()));
        }
        return submittedValue;
    }

    protected void renderInput(FacesContext facesContext, UIComponent component) throws IOException {
        this.renderInputBegin(facesContext, component);
        this.renderInputEnd(facesContext, component);
    }

    protected void renderInputBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"file", null);
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                commonPropertiesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(component);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonHtmlAttributesUtil.renderChangeEventProperty(writer, commonPropertiesMarked, component);
                CommonHtmlAttributesUtil.renderEventProperties(writer, commonPropertiesMarked, component);
                CommonHtmlAttributesUtil.renderFieldEventPropertiesWithoutOnchange(writer, commonPropertiesMarked, component);
            } else {
                HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, component, behaviors);
                if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    long commonEventsMarked = CommonHtmlEventsUtil.getMarkedEvents(component);
                    CommonHtmlEventsUtil.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                    CommonHtmlEventsUtil.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, component, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, component, behaviors);
                }
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonHtmlAttributesUtil.renderInputPassthroughPropertiesWithoutDisabledAndEvents(writer, commonPropertiesMarked, component);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
            }
        } else if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            CommonHtmlAttributesUtil.renderInputPassthroughPropertiesWithoutDisabled(writer, CommonHtmlAttributesUtil.getMarkedAttributes(component), component);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        HtmlInputFile inputFile = (HtmlInputFile)component;
        if (inputFile.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (inputFile.isMultiple()) {
            writer.writeAttribute("multiple", (Object)"multiple", null);
        }
        if (AUTOCOMPLETE_VALUE_OFF.equals(inputFile.getAutocomplete())) {
            writer.writeAttribute("autocomplete", (Object)AUTOCOMPLETE_VALUE_OFF, "autocomplete");
        }
        if (inputFile.getAccept() != null) {
            writer.writeAttribute("accept", (Object)inputFile.getAccept(), "accept");
        }
    }

    protected void renderInputEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("input");
    }

    private static boolean isEmpty(Part part) {
        return part.getSubmittedFileName() == null || part.getSubmittedFileName().isEmpty() || part.getSize() <= 0L;
    }
}

