/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.message.impl;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;
import org.apache.myfaces.extensions.cdi.message.api.NamedArgument;
import org.apache.myfaces.extensions.cdi.message.impl.AbstractFormatterAwareMessageInterpolator;

public class NumberedArgumentAwareMessageInterpolator
extends AbstractFormatterAwareMessageInterpolator {
    private static final long serialVersionUID = 8699632465559596371L;

    public String interpolate(MessageContext messageContext, String messageDescriptor, Serializable ... arguments) {
        Serializable[] numberedArguments = this.extractNumberedArguments(arguments);
        if (numberedArguments.length > 0) {
            return this.formatMessage(messageContext, messageDescriptor, numberedArguments);
        }
        return messageDescriptor;
    }

    private Serializable[] extractNumberedArguments(Serializable[] arguments) {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        for (Serializable argument : arguments) {
            if (argument instanceof NamedArgument) continue;
            result.add(argument);
        }
        return result.toArray(new Serializable[result.size()]);
    }

    private String formatMessage(MessageContext messageContext, String messageDescriptor, Serializable[] arguments) {
        Object[] localizedArguments = null;
        for (int i = 0; i < arguments.length; ++i) {
            Serializable argument = arguments[i];
            Object localizedArgument = this.formatAsString(messageContext, argument);
            if (argument == null) continue;
            if (localizedArguments == null) {
                localizedArguments = this.copyArguments(arguments);
            }
            localizedArguments[i] = localizedArgument;
        }
        MessageFormat messageFormat = new MessageFormat(messageDescriptor, messageContext.getLocale());
        if (localizedArguments == null) {
            return messageFormat.format(arguments);
        }
        return messageFormat.format(localizedArguments);
    }

    private Object[] copyArguments(Object[] arguments) {
        Object[] result = new Object[arguments.length];
        System.arraycopy(arguments, 0, result, 0, arguments.length);
        return result;
    }
}

