/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.message.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.extensions.cdi.message.api.Localizable;
import org.apache.myfaces.extensions.cdi.message.api.Message;
import org.apache.myfaces.extensions.cdi.message.api.MessageContextConfig;
import org.apache.myfaces.extensions.cdi.message.api.MessageContextConfigAware;
import org.apache.myfaces.extensions.cdi.message.api.NamedArgument;
import org.apache.myfaces.extensions.cdi.message.api.payload.MessagePayload;
import org.apache.myfaces.extensions.cdi.message.api.payload.MessagePayloadKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
implements Message,
MessageContextConfigAware<Message> {
    protected String messageDescriptor;
    protected Set<NamedArgument> namedArguments = new HashSet<NamedArgument>();
    protected List<Serializable> arguments = new ArrayList<Serializable>();
    protected Map<Class, MessagePayload> messagePayload = new HashMap<Class, MessagePayload>();
    @Deprecated
    private MessageContextConfig messageContextConfig;

    protected AbstractMessage() {
    }

    public AbstractMessage(Message message) {
        this(message.getDescriptor(), message.getArguments());
        this.messagePayload = message.getPayload();
    }

    public AbstractMessage(String messageDescriptor, Serializable ... arguments) {
        this.messageDescriptor = messageDescriptor;
        for (Serializable argument : arguments) {
            if (argument instanceof MessagePayload) {
                this.addPayload((MessagePayload)argument);
                continue;
            }
            this.addArgument(argument);
        }
        this.cleanup();
    }

    public AbstractMessage(String messageDescriptor, Set<NamedArgument> namedArguments) {
        this.messageDescriptor = messageDescriptor;
        this.namedArguments = namedArguments;
        this.arguments = null;
    }

    @Override
    public Message addArgument(Serializable ... arguments) {
        for (Serializable currentArgument : arguments) {
            Object argument = currentArgument;
            if (argument == null) {
                argument = "null";
            }
            if (this.isHiddenArgument((Serializable)argument)) {
                this.addHiddenArgument((Serializable)argument);
                continue;
            }
            this.addArgumentToMessage(argument);
        }
        return this;
    }

    private void addArgumentToMessage(Object argument) {
        Object result = argument instanceof Serializable ? (Serializable)argument : this.processNoneSerializableArgument(argument);
        this.checkArgument((Serializable)result);
        if (argument instanceof NamedArgument) {
            this.addNamedArgument((NamedArgument)argument);
        } else {
            this.addNumberedArgument((Serializable)result);
        }
    }

    private String processNoneSerializableArgument(Object argument) {
        if (argument instanceof Localizable && this.getMessageContextConfig() != null) {
            return ((Localizable)argument).toString(this.getMessageContextConfig().use().create());
        }
        return argument != null ? argument.toString() : "null";
    }

    private boolean isHiddenArgument(Serializable argument) {
        return argument != null && argument.getClass().isArray();
    }

    private void addHiddenArgument(Serializable argument) {
        for (Object current : (Object[])argument) {
            this.addArgumentToMessage(current);
        }
    }

    private void checkArgument(Serializable argument) {
        if (argument instanceof NamedArgument && this.namedArguments != null) {
            for (NamedArgument namedArgument : this.namedArguments) {
                if (!namedArgument.getName().equals(((NamedArgument)argument).getName())) continue;
                throw new UnsupportedOperationException("it isn't allowed to override arguments - argument name: " + ((NamedArgument)argument).getName());
            }
        }
    }

    protected void addNamedArgument(NamedArgument namedArgument) {
        if (this.namedArguments == null) {
            this.namedArguments = new HashSet<NamedArgument>();
        }
        this.namedArguments.add(namedArgument);
    }

    protected void addNumberedArgument(Serializable argument) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<Serializable>();
        }
        this.arguments.add(argument);
    }

    @Override
    public String getDescriptor() {
        return this.messageDescriptor;
    }

    @Override
    public Serializable[] getArguments() {
        if (this.namedArguments == null && this.arguments == null) {
            return new Serializable[0];
        }
        if (this.namedArguments == null) {
            return this.arguments.toArray(new Serializable[this.arguments.size()]);
        }
        if (this.arguments == null) {
            return this.namedArguments.toArray(new Serializable[this.namedArguments.size()]);
        }
        ArrayList<Serializable> mergedArguments = new ArrayList<Serializable>(this.namedArguments.size() + this.arguments.size());
        mergedArguments.addAll(this.namedArguments);
        mergedArguments.addAll(this.arguments);
        return mergedArguments.toArray(new Serializable[mergedArguments.size()]);
    }

    public void addPayload(MessagePayload payload) {
        Class key = payload.getClass();
        if (payload.getClass().isAnnotationPresent(MessagePayloadKey.class)) {
            key = payload.getClass().getAnnotation(MessagePayloadKey.class).value();
        }
        this.addPayload(key, payload);
    }

    @Override
    public Map<Class, MessagePayload> getPayload() {
        return Collections.unmodifiableMap(this.messagePayload);
    }

    @Override
    public Message addPayload(Class key, MessagePayload payload) {
        if (this.messagePayload.containsKey(key)) {
            throw new UnsupportedOperationException("it isn't allowed to override payload - key: " + key.getName());
        }
        this.messagePayload.put(key, payload);
        return this;
    }

    @Override
    public Message setMessageContextConfig(MessageContextConfig messageContextConfig) {
        this.messageContextConfig = messageContextConfig;
        return this;
    }

    @Override
    public MessageContextConfig getMessageContextConfig() {
        return this.messageContextConfig;
    }

    private void cleanup() {
        if (this.namedArguments != null && this.namedArguments.isEmpty()) {
            this.namedArguments = null;
        }
        if (this.arguments != null && this.arguments.isEmpty()) {
            this.arguments = null;
        }
    }

    protected MessagePayload[] getMessagePayload() {
        MessagePayload[] result = new MessagePayload[this.getPayload().size()];
        int i = 0;
        Iterator<MessagePayload> i$ = this.getPayload().values().iterator();
        while (i$.hasNext()) {
            MessagePayload payload;
            result[i] = payload = i$.next();
            ++i;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractMessage)) {
            return false;
        }
        AbstractMessage that = (AbstractMessage)o;
        if (this.messagePayload != null ? !this.messagePayload.equals(that.messagePayload) : that.messagePayload != null) {
            return false;
        }
        if (!this.getDescriptor().equals(that.getDescriptor())) {
            return false;
        }
        if (this.namedArguments != null ? !this.namedArguments.equals(that.namedArguments) : that.namedArguments != null) {
            return false;
        }
        return !(this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null);
    }

    public int hashCode() {
        int result = this.getDescriptor().hashCode();
        result = 31 * result + (this.namedArguments != null ? this.namedArguments.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        result = 31 * result + (this.messagePayload != null ? this.messagePayload.hashCode() : 0);
        return result;
    }
}

