/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.ConversationConfig;
import org.apache.myfaces.extensions.cdi.core.api.security.BeanCreationDecisionVoter;
import org.apache.myfaces.extensions.cdi.core.api.security.SecurityViolation;
import org.apache.myfaces.extensions.cdi.core.api.tools.InvocationOrderComparator;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.AbstractGroupedConversationContext;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.spi.BeanEntry;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.spi.BeanEntryFactory;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.spi.WindowContextManager;
import org.apache.myfaces.extensions.cdi.core.impl.util.AnyLiteral;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableConversation;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContext;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContextManager;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ExceptionUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.RequestCache;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.WeldCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroupedConversationContext
extends AbstractGroupedConversationContext {
    private List<BeanCreationDecisionVoter> beanCreationDecisionVoters;

    GroupedConversationContext(BeanManager beanManager) {
        super(beanManager);
    }

    public boolean isActive() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return false;
        }
        if (facesContext.getExternalContext().getSession(false) != null) {
            return true;
        }
        if (facesContext.getExternalContext().getRequest() != null) {
            if (!Boolean.FALSE.equals(CodiUtils.lookupFromEnvironment((String)"FORCE_SESSION_CREATION", Boolean.class, (Serializable[])new Boolean[0]))) {
                facesContext.getExternalContext().getSession(true);
            }
            return true;
        }
        return false;
    }

    protected <T> Set<SecurityViolation> checkPermission(Bean<T> bean) {
        this.lazyInit();
        HashSet<SecurityViolation> violations = new HashSet<SecurityViolation>();
        for (BeanCreationDecisionVoter beanCreationDecisionVoter : this.beanCreationDecisionVoters) {
            Set currentViolations = beanCreationDecisionVoter.checkPermission(bean);
            if (currentViolations == null) continue;
            violations.addAll(currentViolations);
        }
        return violations;
    }

    private void lazyInit() {
        if (this.beanCreationDecisionVoters == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.beanCreationDecisionVoters == null) {
            this.beanCreationDecisionVoters = new ArrayList<BeanCreationDecisionVoter>();
            Set foundBeans = this.beanManager.getBeans(BeanCreationDecisionVoter.class, new Annotation[]{new AnyLiteral()});
            for (Bean currentBean : foundBeans) {
                HashSet<Bean> beanSet = new HashSet<Bean>(1);
                beanSet.add(currentBean);
                Bean foundBean = this.beanManager.resolve(beanSet);
                this.beanCreationDecisionVoters.add((BeanCreationDecisionVoter)CodiUtils.getContextualReference((BeanManager)this.beanManager, BeanCreationDecisionVoter.class, (Bean)foundBean));
            }
            Collections.sort(this.beanCreationDecisionVoters, new InvocationOrderComparator());
        }
    }

    protected WindowContextManager resolveWindowContextManager() {
        return RequestCache.getWindowContextManager();
    }

    protected BeanEntryFactory resolveBeanEntryFactory() {
        return RequestCache.getBeanEntryFactory();
    }

    protected <T> T resolveBeanInstance(WindowContextManager windowContextManager, Bean<T> beanDescriptor) {
        if (!(windowContextManager instanceof EditableWindowContextManager)) {
            throw ExceptionUtils.windowContextManagerNotEditableException(windowContextManager);
        }
        Class beanClass = beanDescriptor.getBeanClass();
        EditableConversation foundConversation = this.getConversation((EditableWindowContextManager)windowContextManager, beanDescriptor);
        return foundConversation.getBean(beanClass);
    }

    protected <T> void scopeBeanEntry(WindowContextManager windowContextManager, BeanEntry<T> beanEntry) {
        if (!(windowContextManager instanceof EditableWindowContextManager)) {
            throw ExceptionUtils.windowContextManagerNotEditableException(windowContextManager);
        }
        Bean bean = beanEntry.getBean();
        EditableConversation foundConversation = this.getConversation((EditableWindowContextManager)windowContextManager, bean);
        foundConversation.addBean(beanEntry);
    }

    protected ConversationConfig getConversationConfig() {
        return (ConversationConfig)CodiUtils.getContextualReferenceByClass(ConversationConfig.class, (Annotation[])new Annotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditableConversation getConversation(EditableWindowContextManager windowContextManager, Bean<?> bean) {
        Class conversationGroup = ConversationUtils.getConversationGroup(bean);
        Set qualifiers = bean.getQualifiers();
        EditableWindowContext editableWindowContext = (EditableWindowContext)RequestCache.getCurrentWindowContext();
        if (editableWindowContext == null) {
            editableWindowContext = (EditableWindowContext)windowContextManager.getCurrentWindowContext();
            RequestCache.setCurrentWindowContext(editableWindowContext);
        }
        try {
            if (this.useFallback) {
                WeldCache.setBean(bean);
            }
            EditableConversation editableConversation = editableWindowContext.getConversation(conversationGroup, qualifiers.toArray(new Annotation[qualifiers.size()]));
            return editableConversation;
        }
        finally {
            if (this.useFallback) {
                WeldCache.resetBean();
            }
        }
    }
}

