/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.metadata.transformer.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.myfaces.extensions.validator.core.InvocationOrder;
import org.apache.myfaces.extensions.validator.core.InvocationOrderComparator;
import org.apache.myfaces.extensions.validator.core.Nested;
import org.apache.myfaces.extensions.validator.core.mapper.NameMapper;
import org.apache.myfaces.extensions.validator.core.mapper.SubMapperAwareNameMapper;
import org.apache.myfaces.extensions.validator.core.metadata.transformer.mapper.AbstractValidationStrategyToMetaDataTransformerNameMapper;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InvocationOrder(value=100)
@UsageInformation(value={UsageCategory.INTERNAL})
public class ValidationStrategyToMetaDataTransformerSubMapperAwareNameMapper
extends AbstractValidationStrategyToMetaDataTransformerNameMapper
implements SubMapperAwareNameMapper<ValidationStrategy> {
    private List<NameMapper<ValidationStrategy>> subNameMappers = new CopyOnWriteArrayList<NameMapper<ValidationStrategy>>();

    @Override
    public void addNameMapper(NameMapper<ValidationStrategy> nameMapper) {
        if (!this.subNameMappers.contains(nameMapper) && nameMapper.getClass().isAnnotationPresent(Nested.class)) {
            this.subNameMappers.add(nameMapper);
            this.sortSubNameMappers();
        }
    }

    @Override
    public void removeNameMapper(Class<? extends NameMapper> nameMapperClass) {
        ArrayList<NameMapper<ValidationStrategy>> nameMappersToRemove = new ArrayList<NameMapper<ValidationStrategy>>(this.subNameMappers.size());
        for (NameMapper<ValidationStrategy> currentSubNameMapper : this.subNameMappers) {
            if (!currentSubNameMapper.getClass().getName().equals(nameMapperClass.getName())) continue;
            nameMappersToRemove.add(currentSubNameMapper);
        }
        for (NameMapper<ValidationStrategy> currentSubNameMapper : nameMappersToRemove) {
            this.subNameMappers.remove(currentSubNameMapper);
        }
    }

    private void sortSubNameMappers() {
        ArrayList<NameMapper<ValidationStrategy>> sortableList = new ArrayList<NameMapper<ValidationStrategy>>(this.subNameMappers);
        Collections.sort(sortableList, new InvocationOrderComparator());
        this.subNameMappers.clear();
        this.subNameMappers.addAll(sortableList);
    }

    @Override
    public String createName(ValidationStrategy source) {
        String result = null;
        for (NameMapper<ValidationStrategy> mapper : this.subNameMappers) {
            result = mapper.createName(source);
            if (result == null) continue;
            return result;
        }
        return result;
    }
}

