/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.storage;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.factory.AbstractNameMapperAwareFactory;
import org.apache.myfaces.extensions.validator.core.mapper.NameMapper;
import org.apache.myfaces.extensions.validator.core.storage.StorageManager;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.REUSE})
public abstract class AbstractStorageManager<T>
extends AbstractNameMapperAwareFactory<String>
implements StorageManager<T> {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private List<NameMapper<String>> nameMapperList = new CopyOnWriteArrayList<NameMapper<String>>();

    public AbstractStorageManager() {
        this.logger.fine(this.getClass().getName() + " instantiated");
    }

    @Override
    public T create(String storageName) {
        for (NameMapper<String> nameMapper : this.nameMapperList) {
            T storageManager;
            String storageClassName = nameMapper.createName(storageName);
            if (storageClassName == null || (storageManager = this.resolveStorage(storageName, storageClassName)) == null) continue;
            return storageManager;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T resolveStorage(String storageKey, String storageClassName) {
        Map<String, T> storageMap = this.resolveStorageMap();
        if (!storageMap.containsKey(storageKey)) {
            Map<String, T> map = storageMap;
            synchronized (map) {
                storageMap.put(storageKey, ClassUtils.tryToInstantiateClassForName(storageClassName));
            }
        }
        return storageMap.get(storageKey);
    }

    protected abstract Map<String, T> resolveStorageMap();

    @Override
    public synchronized void reset(String storageKey) {
        Map<String, T> storageMap = this.resolveStorageMap();
        if (storageMap != null && storageMap.containsKey(storageKey)) {
            Class storageClass = ProxyUtils.getUnproxiedClass(storageMap.get(storageKey).getClass());
            storageMap.put(storageKey, ClassUtils.tryToInstantiateClass(storageClass));
        }
    }

    @Override
    protected List<NameMapper<String>> getNameMapperList() {
        return this.nameMapperList;
    }

    public abstract String getStorageManagerKey();
}

