/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.interceptor;

import java.lang.reflect.Method;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.ActionSource2;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.extensions.validator.core.el.ELHelper;
import org.apache.myfaces.extensions.validator.core.el.ValueBindingExpression;
import org.apache.myfaces.extensions.validator.core.factory.ExtValAjaxBehavior;
import org.apache.myfaces.extensions.validator.core.interceptor.ViewRootInterceptor;
import org.apache.myfaces.extensions.validator.core.validation.SkipConstraintValidation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;

public class ExtValViewRootInterceptor
implements ViewRootInterceptor {
    public void afterQueueEvent(FacesEvent event) {
        UIComponent uiComponent = event.getComponent();
        if (event instanceof ActionEvent && uiComponent instanceof ActionSource2) {
            this.tryToProcessActionMethod((ActionSource2)event.getComponent());
        }
        if (event instanceof AjaxBehaviorEvent && uiComponent instanceof EditableValueHolder && ((AjaxBehaviorEvent)event).getBehavior() instanceof AjaxBehavior) {
            this.tryToProcessAjaxListener((AjaxBehavior)((AjaxBehaviorEvent)event).getBehavior());
        }
    }

    protected void tryToProcessActionMethod(ActionSource2 commandComponent) {
        String actionString;
        MethodExpression actionExpression = commandComponent.getActionExpression();
        if (actionExpression == null) {
            return;
        }
        ELHelper elHelper = ExtValUtils.getELHelper();
        if (!elHelper.isELTermWellFormed(actionString = actionExpression.getExpressionString())) {
            return;
        }
        ValueBindingExpression valueBindingExpression = new ValueBindingExpression(actionString);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!ExtValUtils.getELHelper().isELTermValid(facesContext, valueBindingExpression.getBaseExpression().getExpressionString())) {
            return;
        }
        this.processBypassValidation(facesContext, valueBindingExpression, elHelper, ActionEvent.class);
    }

    protected void tryToProcessAjaxListener(AjaxBehavior ajaxBehavior) {
        if (!(ajaxBehavior instanceof ExtValAjaxBehavior)) {
            return;
        }
        List<MethodExpression> listenerExpressions = ((ExtValAjaxBehavior)ajaxBehavior).getListenerExpressions();
        ELHelper elHelper = ExtValUtils.getELHelper();
        for (MethodExpression listenerExpression : listenerExpressions) {
            String actionString = listenerExpression.getExpressionString();
            if (!elHelper.isELTermWellFormed(actionString)) continue;
            ValueBindingExpression valueBindingExpression = new ValueBindingExpression(actionString);
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (!ExtValUtils.getELHelper().isELTermValid(facesContext, valueBindingExpression.getBaseExpression().getExpressionString())) continue;
            this.processBypassValidation(facesContext, valueBindingExpression, elHelper, AjaxBehaviorEvent.class);
        }
    }

    protected void processBypassValidation(FacesContext facesContext, ValueBindingExpression valueBindingExpression, ELHelper elHelper, Class ... parameterTypes) {
        Method actionMethod;
        Object base = elHelper.getValueOfExpression(facesContext, valueBindingExpression.getBaseExpression());
        if (base == null) {
            return;
        }
        String methodName = valueBindingExpression.getProperty();
        if (methodName.contains("(")) {
            methodName = methodName.substring(0, methodName.indexOf("("));
        }
        if ((actionMethod = ReflectionUtils.tryToGetMethod(ProxyUtils.getUnproxiedClass(base.getClass()), methodName)) == null) {
            actionMethod = ReflectionUtils.tryToGetMethod(ProxyUtils.getUnproxiedClass(base.getClass()), methodName, parameterTypes);
        }
        if (actionMethod == null) {
            return;
        }
        SkipConstraintValidation skipConstraintValidation = actionMethod.getAnnotation(SkipConstraintValidation.class);
        if (skipConstraintValidation == null) {
            return;
        }
        facesContext.getExternalContext().getRequestMap().put("skip_validation", Boolean.TRUE);
    }
}

