/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.interceptor;

import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.extensions.validator.core.InvocationOrder;
import org.apache.myfaces.extensions.validator.core.interceptor.ValidationExceptionInterceptor;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.validation.parameter.ViolationSeverity;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

@InvocationOrder(value=90)
@UsageInformation(value={UsageCategory.INTERNAL})
public class ViolationSeverityValidationExceptionInterceptor
implements ValidationExceptionInterceptor {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    public boolean afterThrowing(UIComponent uiComponent, MetaDataEntry metaDataEntry, Object convertedObject, ValidatorException validatorException, ValidationStrategy validatorExceptionSource) {
        if (this.isExtValMetaData(metaDataEntry)) {
            this.tryToPlaceSeverity(validatorException, metaDataEntry.getValue(Annotation.class));
        }
        return true;
    }

    private boolean isExtValMetaData(MetaDataEntry metaDataEntry) {
        return metaDataEntry.getValue() instanceof Annotation;
    }

    private void tryToPlaceSeverity(ValidatorException validatorException, Annotation annotation) {
        for (FacesMessage.Severity severity : ExtValUtils.getValidationParameterExtractor().extract(annotation, ExtValUtils.getValidationParameterClassFor(ViolationSeverity.class), FacesMessage.Severity.class)) {
            validatorException.getFacesMessage().setSeverity(severity);
        }
    }
}

