/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.cargo;

import java.io.File;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.util.log.FileLogger;
import org.codehaus.cargo.util.log.Logger;

public class CargoTestSetup
extends TestSetup {
    private InstalledLocalContainer container;

    public CargoTestSetup(Test test) {
        super(test);
    }

    protected void setUp() throws Exception {
        String containerOutput;
        super.setUp();
        String containerId = System.getProperty("cargo.container.id");
        if (containerId == null) {
            containerId = "tomcat5x";
        }
        System.out.println("[INFO] container id: " + containerId);
        String deployablePath = System.getProperty("cargo.deployable");
        System.out.println("[INFO] deployable: " + deployablePath);
        Deployable war = new DefaultDeployableFactory().createDeployable(containerId, deployablePath, DeployableType.WAR);
        DefaultConfigurationFactory configurationFactory = new DefaultConfigurationFactory();
        LocalConfiguration configuration = (LocalConfiguration)configurationFactory.createConfiguration(containerId, ConfigurationType.STANDALONE);
        String servletPort = System.getProperty("cargo.servlet.port");
        if (servletPort != null) {
            configuration.setProperty("cargo.servlet.port", servletPort);
            System.out.println("[INFO] servlet port: " + servletPort);
        }
        configuration.addDeployable(war);
        this.container = (InstalledLocalContainer)new DefaultContainerFactory().createContainer(containerId, ContainerType.INSTALLED, (Configuration)configuration);
        String containerHome = System.getProperty("cargo.container.home");
        if (containerHome == null || containerHome.startsWith("$")) {
            containerHome = System.getenv("TOMCAT_HOME");
        }
        System.out.println("[INFO] container home: " + containerHome);
        this.container.setHome(new File(containerHome));
        String containerLog = System.getProperty("cargo.container.log");
        if (containerLog != null) {
            System.out.println("[INFO] container log: " + containerLog);
            this.container.setLogger((Logger)new FileLogger(containerLog, false));
        }
        if ((containerOutput = System.getProperty("cargo.container.output")) != null) {
            System.out.println("[INFO] container output: " + containerOutput);
            this.container.setOutput(new File(containerOutput));
        }
        this.container.start();
    }

    protected void tearDown() throws Exception {
        this.container.stop();
        super.tearDown();
    }

    public String getName() {
        return "CargoTestSetup";
    }
}

