/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.datalist;

import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.component.html.ext.HtmlDataTableHack;

public abstract class AbstractHtmlDataList
extends HtmlDataTableHack
implements UserRoleAware {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlDataList";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.List";
    private static Log log = LogFactory.getLog((Class)AbstractHtmlDataList.class);
    private static final int PROCESS_DECODES = 1;
    private static final int PROCESS_VALIDATORS = 2;
    private static final int PROCESS_UPDATES = 3;

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processChildren(context, 1);
        this.setRowIndex(-1);
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processChildren(context, 3);
        this.setRowIndex(-1);
        this.checkUpdateModelError(context);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processChildren(context, 2);
        this.setRowIndex(-1);
        this.checkUpdateModelError(context);
    }

    public void processChildren(FacesContext context, int processAction) {
        int last;
        int first = this.getFirst();
        int rows = this.getRows();
        int n = last = rows == 0 ? this.getRowCount() : first + rows;
        if (log.isTraceEnabled()) {
            log.trace((Object)("processing " + this.getChildCount() + " children: starting at " + first + ", ending at " + last));
        }
        for (int rowIndex = first; last == -1 || rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) {
                if (!log.isTraceEnabled()) break;
                log.trace((Object)"scrolled past the last row, aborting");
                break;
            }
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                if (!child.isRendered()) continue;
                this.process(context, child, processAction);
            }
        }
    }

    private void process(FacesContext context, UIComponent component, int processAction) {
        switch (processAction) {
            case 1: {
                component.processDecodes(context);
                break;
            }
            case 2: {
                component.processValidators(context);
                break;
            }
            case 3: {
                component.processUpdates(context);
            }
        }
    }

    public void setRowIndex(int rowIndex) {
        super.setRowIndex(rowIndex);
        String rowIndexVar = this.getRowIndexVar();
        String rowCountVar = this.getRowCountVar();
        if (rowIndexVar != null || rowCountVar != null) {
            Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
            if (rowIndex >= 0) {
                if (rowIndexVar != null) {
                    requestMap.put(this.getRowIndexVar(), new Integer(rowIndex));
                }
                if (rowCountVar != null) {
                    requestMap.put(this.getRowCountVar(), new Integer(this.getRowCount()));
                }
            } else {
                if (rowIndexVar != null) {
                    requestMap.remove(this.getRowIndexVar());
                }
                if (rowCountVar != null) {
                    requestMap.remove(this.getRowCountVar());
                }
            }
        }
    }

    protected void restoreDescendantComponentStates(Object state) {
        this.restoreDescendantComponentStates(this.getChildren().iterator(), state, true);
    }

    protected Object saveDescendantComponentStates() {
        return this.saveDescendantComponentStates(this.getChildren().iterator(), true);
    }

    public abstract String getRowCountVar();

    public abstract String getRowIndexVar();

    public abstract String getLayout();

    public abstract String getItemStyleClass();

    public abstract String getItemOnClick();
}

