/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.myfaces.custom.schedule.model.Day;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.model.ScheduleModel;
import org.apache.myfaces.custom.schedule.util.ScheduleUtil;

public abstract class AbstractScheduleModel
implements ScheduleModel,
Serializable {
    private TreeSet days;
    private Date selectedDate = new Date();
    private ScheduleEntry selectedEntry;
    private int mode;
    protected final TimeZone timeZone;

    public AbstractScheduleModel() {
        this(TimeZone.getDefault());
    }

    public AbstractScheduleModel(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    protected SortedSet getDays() {
        if (this.days == null) {
            this.days = new TreeSet();
            switch (this.mode) {
                case 0: {
                    this.setDay(this.selectedDate);
                    break;
                }
                case 1: {
                    this.setWorkWeek(this.selectedDate);
                    break;
                }
                case 2: {
                    this.setWeek(this.selectedDate);
                    break;
                }
                case 3: {
                    this.setMonth(this.selectedDate);
                    break;
                }
                default: {
                    this.setDay(this.selectedDate);
                }
            }
        }
        return this.days;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public boolean isEmpty() {
        return this.getDays().isEmpty();
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setSelectedDate(Date date) {
        if (date == null) {
            return;
        }
        this.selectedDate = date;
        this.days = null;
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedEntry(ScheduleEntry selectedEntry) {
        this.selectedEntry = selectedEntry;
    }

    public ScheduleEntry getSelectedEntry() {
        return this.selectedEntry;
    }

    public boolean isEntrySelected() {
        return this.getSelectedEntry() != null;
    }

    public boolean containsDate(Date date) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)iterator.next();
            if (!day.equalsDate(date)) continue;
            return true;
        }
        return false;
    }

    public Object get(int index) {
        Object[] dayArray = this.getDays().toArray();
        Object returnObject = dayArray[index];
        return returnObject;
    }

    public Iterator iterator() {
        return this.getDays().iterator();
    }

    public int size() {
        return this.getDays().size();
    }

    protected void setDay(Date date) {
        if (date == null) {
            return;
        }
        this.clear();
        ScheduleDay day = this.add(date);
        this.load(day.getDayStart(), day.getDayEnd());
    }

    protected void setMonth(Date date) {
        if (date == null) {
            return;
        }
        this.clear();
        Calendar cal = this.getCalendarInstance(date);
        cal.set(5, cal.getMinimum(5));
        Date temp = cal.getTime();
        cal.add(2, 1);
        int nextMonth = cal.get(2);
        cal.setTime(temp);
        ScheduleDay firstDay = null;
        ScheduleDay lastDay = null;
        cal.set(7, 2);
        do {
            ScheduleDay addedDay = this.add(cal.getTime());
            if (firstDay == null) {
                firstDay = addedDay;
            }
            lastDay = addedDay;
            cal.add(5, 1);
        } while (cal.get(2) != nextMonth || cal.get(7) != 2);
        this.load(firstDay.getDayStart(), lastDay.getDayEnd());
    }

    protected void setWeek(Date date) {
        if (date == null) {
            return;
        }
        this.clear();
        Calendar cal = this.getCalendarInstance(date);
        cal.set(7, 2);
        Day firstDay = null;
        Day lastDay = null;
        for (int i = 0; i < 7; ++i) {
            ScheduleDay addedDay = this.add(cal.getTime());
            if (firstDay == null) {
                firstDay = addedDay;
            }
            lastDay = addedDay;
            cal.add(5, 1);
        }
        this.load(firstDay.getDayStart(), lastDay.getDayEnd());
    }

    protected void setWorkWeek(Date date) {
        if (date == null) {
            return;
        }
        this.clear();
        Calendar cal = this.getCalendarInstance(date);
        cal.set(7, 2);
        Day firstDay = null;
        Day lastDay = null;
        for (int i = 0; i < 5; ++i) {
            ScheduleDay addedDay = this.add(cal.getTime());
            if (firstDay == null) {
                firstDay = addedDay;
            }
            lastDay = addedDay;
            cal.add(5, 1);
        }
        this.load(firstDay.getDayStart(), lastDay.getDayEnd());
    }

    protected ScheduleDay add(Date date) {
        if (date == null) {
            return null;
        }
        ScheduleDay day = new ScheduleDay(date, this.getTimeZone());
        this.loadDayAttributes(day);
        this.getDays().add(day);
        return day;
    }

    protected void clear() {
        if (this.days != null) {
            Iterator dayIterator = this.days.iterator();
            while (dayIterator.hasNext()) {
                ScheduleDay day = (ScheduleDay)dayIterator.next();
                day.clear();
            }
            this.days.clear();
        }
    }

    public void refresh() {
        this.setSelectedDate(this.selectedDate);
    }

    protected abstract Collection loadEntries(Date var1, Date var2);

    protected abstract void loadDayAttributes(Day var1);

    public boolean containsRepeatedIntervals() {
        boolean firstDay = true;
        TreeSet firstDayIntervals = null;
        if (this.mode == 0) {
            return true;
        }
        Iterator dayIterator = this.iterator();
        while (dayIterator.hasNext()) {
            Day day = (Day)dayIterator.next();
            if (firstDay) {
                firstDayIntervals = day.getIntervals();
                firstDay = false;
                continue;
            }
            if (!(firstDayIntervals == null || firstDayIntervals.size() == 0 ? day.getIntervals() != null && day.getIntervals().size() > 0 : !ScheduleUtil.areEquivalentIntervals(firstDayIntervals, day.getIntervals()))) continue;
            return false;
        }
        return true;
    }

    private void load(Date startDate, Date endDate) {
        Collection entries = this.loadEntries(startDate, endDate);
        Iterator entryIterator = entries.iterator();
        while (entryIterator.hasNext()) {
            ScheduleEntry entry = (ScheduleEntry)entryIterator.next();
            Iterator dayIterator = this.getDays().iterator();
            while (dayIterator.hasNext()) {
                ScheduleDay day = (ScheduleDay)dayIterator.next();
                day.addEntry(entry);
            }
        }
    }

    protected Calendar getCalendarInstance(Date date) {
        return ScheduleUtil.getCalendarInstance(date, this.getTimeZone());
    }
}

