/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.annotation.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.annotation.AnnotationInfo;
import org.apache.myfaces.orchestra.annotation.AnnotationInfoManager;
import org.apache.myfaces.orchestra.conversation.annotations.ConversationName;
import org.apache.myfaces.orchestra.conversation.spring._SpringUtils;
import org.apache.myfaces.shared_orchestra.util.ClassUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;

public class AnnotationsInfoInitializer
implements BeanFactoryPostProcessor,
Ordered {
    private Log log = LogFactory.getLog(AnnotationsInfoInitializer.class);
    private int order = Integer.MAX_VALUE;
    private AnnotationInfoManager annotationInfoManager;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setAnnotationInfoManager(AnnotationInfoManager annotationInfoManager) {
        this.annotationInfoManager = annotationInfoManager;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames;
        for (String beanName : beanNames = beanFactory.getBeanDefinitionNames()) {
            String alternateBeanName;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            String className = beanDefinition.getBeanClassName();
            if (className == null) continue;
            Class beanClass = null;
            try {
                beanClass = ClassUtils.classForName((String)className);
            }
            catch (ClassNotFoundException e) {
                this.log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (beanClass == null || !_SpringUtils.isAlternateBeanName((String)beanName) && beanFactory.containsBeanDefinition(alternateBeanName = _SpringUtils.getAlternateBeanName((String)beanName))) continue;
            String realBeanName = _SpringUtils.getRealBeanName((String)beanName);
            this.annotationInfoManager.processBeanAnnotations(realBeanName, beanClass);
            AnnotationInfo info = this.annotationInfoManager.getAnnotationInfoByBeanName(realBeanName);
            if (info == null) continue;
            this.processStartupAnnotations(beanDefinition, info);
        }
    }

    private void processStartupAnnotations(BeanDefinition beanDefinition, AnnotationInfo info) {
        String convNameFromDef;
        String convNameFromAnno;
        ConversationName conversationName = info.getConversationName();
        if (conversationName != null && (convNameFromAnno = conversationName.value()) != null && convNameFromAnno.length() > 0 && (convNameFromDef = AnnotationsInfoInitializer.getConversationName(beanDefinition)) == null) {
            AnnotationsInfoInitializer.setConversationName(beanDefinition, convNameFromAnno);
        }
    }

    private static String getConversationName(BeanDefinition def) {
        return (String)def.getAttribute("org.apache.myfaces.orchestra.spring.conversationName");
    }

    private static void setConversationName(BeanDefinition def, String convName) {
        def.setAttribute("org.apache.myfaces.orchestra.spring.conversationName", (Object)convName);
    }
}

