/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.converter;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.servlet.jsp.JspException;

/**
 * ConverterBaseTag provides support for ConverterBase subclasses.
 * ConverterBaseTag subclass tld entries should include the following to pick up attribute defintions.
 *         &ext_converter_base_attributes;
 * 
 * @author mkienenb (latest modification by $Author: lu4242 $)
 * @version $Revision: 706423 $
 */
public abstract class ConverterBaseTag extends ConverterTag {
    private static final long serialVersionUID = 4416508071412794682L;
    private ValueExpression _detailMessage = null;
    private ValueExpression _summaryMessage = null;

    public void setDetailMessage(ValueExpression detailMessage)
    {
        _detailMessage = detailMessage;
    }

    public void setSummaryMessage(ValueExpression summaryMessage)
    {
        _summaryMessage = summaryMessage;
    }

    protected Converter createConverter() throws JspException
    {
        ConverterBase converter = (ConverterBase) super.createConverter();
        
        FacesContext facesContext = FacesContext.getCurrentInstance();

        if (_detailMessage != null)
        {
            if (!_detailMessage.isLiteralText())
            {
                converter.setValueExpression("detailMessage",_detailMessage);
            }
            else
            {
                converter.setDetailMessage((String)_detailMessage.getValue(facesContext.getELContext()));
            }
        }

        if (_summaryMessage != null)
        {
            if (!_summaryMessage.isLiteralText())
            {
                converter.setValueExpression("summaryMessage",_summaryMessage);
            }
            else
            {
                converter.setSummaryMessage((String)_summaryMessage.getValue(facesContext.getELContext()));
            }
        }
        
        return converter;
    }
    
    public void release()
    {
        super.release();
        _detailMessage = null;
        _summaryMessage = null;
    }
}
