"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorData = exports.ErrorType = void 0;
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const Const_1 = require("../core/Const");
const EventData_1 = require("./EventData");
const Lang_1 = require("../util/Lang");
var getMessage = Lang_1.ExtLang.getMessage;
var ErrorType;
(function (ErrorType) {
    ErrorType["SERVER_ERROR"] = "serverError";
    ErrorType["HTTP_ERROR"] = "httpError";
    ErrorType["CLIENT_ERROR"] = "clientErrror";
    ErrorType["TIMEOUT"] = "timeout";
})(ErrorType || (exports.ErrorType = ErrorType = {}));
/**
 * the spec has a problem of having the error
 * object somewhat underspecified, there is no clear
 * description of the required contents.
 * I want to streamline it with mojarra here
 * hence we are going to move
 * everything into the same attributes,
 * I will add deprecated myfaces backwards compatibility attributes as well
 */
class ErrorData extends EventData_1.EventData {
    constructor(source, errorName, errorMessage, responseText = null, responseXML = null, responseCode = "200", status = "", type = ErrorType.CLIENT_ERROR) {
        super();
        this.type = "error";
        this.source = document.getElementById(source);
        this.sourceId = source;
        this.type = Const_1.ERROR;
        this.errorName = errorName;
        //tck requires that the type is prefixed to the message itself (jsdoc also) in case of a server error
        this.message = this.errorMessage = (type == Const_1.SERVER_ERROR) ? type + ": " + errorMessage : errorMessage;
        this.responseCode = responseCode;
        this.responseText = responseText;
        this.status = status;
        this.typeDetails = type;
        if (type == ErrorType.SERVER_ERROR) {
            this.serverErrorName = this.errorName;
            this.serverErrorMessage = this.errorMessage;
        }
    }
    static fromClient(e) {
        var _a, _b, _c, _d;
        return new ErrorData((_a = e === null || e === void 0 ? void 0 : e.source) !== null && _a !== void 0 ? _a : "client", (_b = e === null || e === void 0 ? void 0 : e.name) !== null && _b !== void 0 ? _b : Const_1.EMPTY_STR, (_c = e === null || e === void 0 ? void 0 : e.message) !== null && _c !== void 0 ? _c : Const_1.EMPTY_STR, (_d = e === null || e === void 0 ? void 0 : e.stack) !== null && _d !== void 0 ? _d : Const_1.EMPTY_STR);
    }
    static fromHttpConnection(source, name, message, responseText, responseCode, status = Const_1.EMPTY_STR) {
        return new ErrorData(source, name, message, responseText, responseCode, `${responseCode}`, status, ErrorType.HTTP_ERROR);
    }
    static fromGeneric(context, errorCode, errorType = ErrorType.SERVER_ERROR) {
        let getMsg = this.getMsg;
        let source = getMsg(context, Const_1.SOURCE);
        let errorName = getMsg(context, Const_1.ERROR_NAME);
        let errorMessage = getMsg(context, Const_1.ERROR_MESSAGE);
        let status = getMsg(context, Const_1.STATUS);
        let responseText = getMsg(context, Const_1.RESPONSE_TEXT);
        let responseXML = getMsg(context, Const_1.RESPONSE_XML);
        return new ErrorData(source, errorName, errorMessage, responseText, responseXML, errorCode + Const_1.EMPTY_STR, status, errorType);
    }
    static getMsg(context, param) {
        return getMessage(context.getIf(param).orElse(Const_1.EMPTY_STR).value);
    }
    static fromServerError(context) {
        return this.fromGeneric(context, -1);
    }
}
exports.ErrorData = ErrorData;
//# sourceMappingURL=ErrorData.js.map