/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.tobago.renderkit.html.scarborough.standard;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public abstract class AbstractJavaScriptTestBase {

  private Context cx;
  private Scriptable scope;

  @Before
  protected void setUp() throws Exception {
    cx = Context.enter();
    scope = cx.initStandardObjects(null);
  }

  @After
  protected void tearDown() throws Exception {
    Context.exit();
  }

  @Test
  public void testDummy() {

  }

  protected Object eval(final String script) {
    return cx.evaluateString(scope, script, "test", 1, null);
  }

  protected int evalInt(final String script) {
    final Object o = eval(script);
    if (o instanceof Number) {
      return ((Number) o).intValue();
    }
    throw new JavaScriptException(null, "invalid return type "
        + o.getClass().getName() + " with value " + o, 0);
  }

  protected long evalLong(final String script) {
    final Object o = eval(script);
    if (o instanceof Number) {
      return ((Number) o).longValue();
    }
    throw new JavaScriptException(null, "invalid return type "
        + o.getClass().getName() + " with value " + o, 0);
  }

  protected boolean evalBoolean(final String script) {
    final Object o = eval(script);
    if (o instanceof Boolean) {
      return ((Boolean) o).booleanValue();
    }
    throw new JavaScriptException(null, "invalid return type "
        + o.getClass().getName() + " with value " + o, 0);
  }

  // XXX directory handling +  Maven reactor current dir problem
  protected void loadScriptFile(final String jsFile)
      throws IOException {
    String fileName
        = "src/main/resources/org/apache/myfaces/tobago/renderkit/html/scarborough/standard/script/" + jsFile;
    File file = new File(fileName);
    if (!file.exists()) {
      fileName = System.getProperty("basedir") + "/" + fileName;
      file = new File(fileName);
    }
    final FileReader fileReader = new FileReader(file);
    cx.evaluateReader(scope, fileReader, jsFile, 0, null);
  }
}
