/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.util;

import jpt.sun.tools.javac.code.Type;
import jpt.sun.tools.javac.util.Convert;

public class Constants {
    public static Object decode(Object value, Type type) {
        if (value instanceof Integer) {
            Integer intVal = (Integer)value;
            int i = intVal;
            switch (type.getTag()) {
                case BOOLEAN: {
                    return i != 0;
                }
                case CHAR: {
                    return Character.valueOf((char)i);
                }
                case BYTE: {
                    return (byte)i;
                }
                case SHORT: {
                    return (short)i;
                }
            }
        }
        return value;
    }

    public static String format(Object value, Type type) {
        value = Constants.decode(value, type);
        switch (type.getTag()) {
            case BYTE: {
                return Constants.formatByte((Byte)value);
            }
            case LONG: {
                return Constants.formatLong((Long)value);
            }
            case FLOAT: {
                return Constants.formatFloat(((Float)value).floatValue());
            }
            case DOUBLE: {
                return Constants.formatDouble((Double)value);
            }
            case CHAR: {
                return Constants.formatChar(((Character)value).charValue());
            }
        }
        if (value instanceof String) {
            String str = (String)value;
            return Constants.formatString(str);
        }
        return value + "";
    }

    public static String format(Object value) {
        if (value instanceof Byte) {
            Byte byteVal = (Byte)value;
            return Constants.formatByte(byteVal);
        }
        if (value instanceof Short) {
            Short shortVal = (Short)value;
            return Constants.formatShort(shortVal);
        }
        if (value instanceof Long) {
            Long longVal = (Long)value;
            return Constants.formatLong(longVal);
        }
        if (value instanceof Float) {
            Float floatVal = (Float)value;
            return Constants.formatFloat(floatVal.floatValue());
        }
        if (value instanceof Double) {
            Double doubleVal = (Double)value;
            return Constants.formatDouble(doubleVal);
        }
        if (value instanceof Character) {
            Character charVal = (Character)value;
            return Constants.formatChar(charVal.charValue());
        }
        if (value instanceof String) {
            String strVal = (String)value;
            return Constants.formatString(strVal);
        }
        if (value instanceof Integer || value instanceof Boolean) {
            return value.toString();
        }
        throw new IllegalArgumentException("Argument is not a primitive type or a string; it " + (value == null ? "is a null value." : "has class " + value.getClass().getName()) + ".");
    }

    private static String formatByte(byte b) {
        return String.format("(byte)0x%02x", b);
    }

    private static String formatShort(short s) {
        return String.format("(short)%d", s);
    }

    private static String formatLong(long lng) {
        return lng + "L";
    }

    private static String formatFloat(float f) {
        if (Float.isNaN(f)) {
            return "0.0f/0.0f";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-1.0f/0.0f" : "1.0f/0.0f";
        }
        return f + "f";
    }

    private static String formatDouble(double d) {
        if (Double.isNaN(d)) {
            return "0.0/0.0";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-1.0/0.0" : "1.0/0.0";
        }
        return d + "";
    }

    private static String formatChar(char c) {
        return '\'' + Convert.quote(c, true) + '\'';
    }

    private static String formatString(String s) {
        return '\"' + Convert.quote(s) + '\"';
    }
}

