/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.netbeans.api.project.SourceGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

final class LibrariesSourceGroup
implements SourceGroup {
    private final FileObject root;
    private final String displayName;
    private final Icon icon;
    private final Icon openIcon;

    LibrariesSourceGroup(FileObject root, String displayName) {
        this(root, displayName, null, null);
    }

    LibrariesSourceGroup(FileObject root, String displayName, Icon icon, Icon openIcon) {
        Parameters.notNull("root", root);
        assert (root.isFolder()) : "Root: " + FileUtil.getFileDisplayName(root) + " has to be a folder.";
        this.root = root;
        this.displayName = displayName;
        this.icon = icon;
        this.openIcon = openIcon;
    }

    @Override
    public FileObject getRootFolder() {
        return this.root;
    }

    @Override
    public String getName() {
        return this.root.toURL().toExternalForm();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Icon getIcon(boolean opened) {
        return opened ? this.openIcon : this.icon;
    }

    @Override
    public boolean contains(FileObject file) {
        return this.root.equals(file) || FileUtil.isParentOf(this.root, file);
    }

    public boolean equals(Object other) {
        if (!(other instanceof LibrariesSourceGroup)) {
            return false;
        }
        LibrariesSourceGroup osg = (LibrariesSourceGroup)other;
        return this.displayName == null ? osg.displayName == null : (this.displayName.equals(osg.displayName) && this.root == null ? osg.root == null : this.root.equals(osg.root));
    }

    public int hashCode() {
        return (this.displayName == null ? 0 : this.displayName.hashCode()) << 16 | (this.root == null ? 0 : this.root.hashCode()) & 0xFFFF;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }
}

