/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.modules.java.api.common.project.ui.customizer.ClassPathListCellRenderer;
import org.netbeans.modules.java.api.common.project.ui.customizer.SourceRootsUi;
import org.netbeans.modules.java.api.common.ui.PlatformFilter;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerCompile;
import org.netbeans.spi.java.project.support.ui.IncludeExcludeVisualizer;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class J2SEProjectProperties {
    private static final Integer BOOLEAN_KIND_TF = new Integer(0);
    private static final Integer BOOLEAN_KIND_YN = new Integer(1);
    private static final Integer BOOLEAN_KIND_ED = new Integer(2);
    private static final String COS_MARK = ".netbeans_automatic_build";
    private static final Logger LOG = Logger.getLogger(J2SEProjectProperties.class.getName());
    private Integer javacDebugBooleanKind;
    private Integer doJarBooleanKind;
    private Integer javadocPreviewBooleanKind;
    private Integer doJLinkKind;
    private Integer jLinkStripKind;
    private Integer jLinkLauncherKind;
    public static final SpecificationVersion JDK9 = new SpecificationVersion("9");
    public static final String J2SE_PROJECT_NAME = "j2se.project.name";
    public static final String APPLICATION_TITLE = "application.title";
    public static final String APPLICATION_VENDOR = "application.vendor";
    public static final String APPLICATION_DESC = "application.desc";
    public static final String APPLICATION_HOMEPAGE = "application.homepage";
    public static final String APPLICATION_SPLASH = "application.splash";
    public static final String MKDIST_DISABLED = "mkdist.disabled";
    public static final String PLATFORM_RUNTIME = "platform.runtime";
    public static final String JAVAC_EXTERNAL_VM = "javac.external.vm";
    public static final String PROP_PLATFORM_ANT_NAME = "platform.ant.name";
    private static final String[] CONFIG_AWARE_PROPERTIES = new String[]{"main.class", "application.args", "run.jvmargs", "work.dir", "platform.runtime"};
    ClassPathSupport cs;
    DefaultTableModel SOURCE_ROOTS_MODEL;
    DefaultTableModel TEST_ROOTS_MODEL;
    ComboBoxModel JAVAC_SOURCE_MODEL;
    ComboBoxModel JAVAC_PROFILE_MODEL;
    DefaultListModel JAVAC_MODULEPATH_MODEL;
    DefaultListModel JAVAC_CLASSPATH_MODEL;
    DefaultListModel JAVAC_PROCESSORMODULEPATH_MODEL;
    DefaultListModel JAVAC_PROCESSORPATH_MODEL;
    DefaultListModel JAVAC_TEST_MODULEPATH_MODEL;
    DefaultListModel JAVAC_TEST_CLASSPATH_MODEL;
    DefaultListModel RUN_MODULEPATH_MODEL;
    DefaultListModel RUN_CLASSPATH_MODEL;
    DefaultListModel RUN_TEST_MODULEPATH_MODEL;
    DefaultListModel RUN_TEST_CLASSPATH_MODEL;
    DefaultListModel ENDORSED_CLASSPATH_MODEL;
    ComboBoxModel PLATFORM_MODEL;
    ListCellRenderer CLASS_PATH_LIST_RENDERER;
    ListCellRenderer PLATFORM_LIST_RENDERER;
    ListCellRenderer JAVAC_SOURCE_RENDERER;
    ListCellRenderer JAVAC_PROFILE_RENDERER;
    Document SHARED_LIBRARIES_MODEL;
    ButtonModel JAVAC_DEPRECATION_MODEL;
    ButtonModel JAVAC_DEBUG_MODEL;
    ButtonModel DO_DEPEND_MODEL;
    ButtonModel COMPILE_ON_SAVE_MODEL;
    ButtonModel NO_DEPENDENCIES_MODEL;
    ButtonModel ENABLE_ANNOTATION_PROCESSING_MODEL;
    ButtonModel ENABLE_ANNOTATION_PROCESSING_IN_EDITOR_MODEL;
    ButtonModel JAVAC_EXTERNAL_VM_MODEL;
    DefaultListModel ANNOTATION_PROCESSORS_MODEL;
    DefaultTableModel PROCESSOR_OPTIONS_MODEL;
    Document JAVAC_COMPILER_ARG_MODEL;
    Document DIST_JAR_MODEL;
    Document BUILD_CLASSES_EXCLUDES_MODEL;
    ButtonModel JAR_COMPRESS_MODEL;
    ButtonModel DO_JAR_MODEL;
    ButtonModel COPY_LIBS_MODEL;
    ButtonModel JLINK_MODEL;
    ButtonModel JLINK_STRIP_MODEL;
    ButtonModel JLINK_LAUNCHER_MODEL;
    Document JLINK_LAUNCHER_NAME_MODEL;
    ButtonModel JAVADOC_PRIVATE_MODEL;
    ButtonModel JAVADOC_NO_TREE_MODEL;
    ButtonModel JAVADOC_USE_MODEL;
    ButtonModel JAVADOC_NO_NAVBAR_MODEL;
    ButtonModel JAVADOC_NO_INDEX_MODEL;
    ButtonModel JAVADOC_SPLIT_INDEX_MODEL;
    ButtonModel JAVADOC_HTML5_MODEL;
    ButtonModel JAVADOC_AUTHOR_MODEL;
    ButtonModel JAVADOC_VERSION_MODEL;
    Document JAVADOC_WINDOW_TITLE_MODEL;
    ButtonModel JAVADOC_PREVIEW_MODEL;
    Document JAVADOC_ADDITIONALPARAM_MODEL;
    Map<String, Map<String, String>> RUN_CONFIGS;
    String activeConfig;
    Document APPLICATION_TITLE_DOC;
    Document APPLICATION_VENDOR_DOC;
    Document APPLICATION_DESC_DOC;
    Document APPLICATION_HOMEPAGE_DOC;
    Document APPLICATION_SPLASH_DOC;
    String LICENSE_NAME_VALUE;
    String LICENSE_PATH_VALUE;
    String CHANGED_LICENSE_PATH_CONTENT;
    private J2SEProject project;
    private UpdateHelper updateHelper;
    private PropertyEvaluator evaluator;
    private ReferenceHelper refHelper;
    private GeneratedFilesHelper genFileHelper;
    private StoreGroup privateGroup;
    private StoreGroup projectGroup;
    private Map<String, String> additionalProperties;
    private String includes;
    private String excludes;
    private final List<ActionListener> optionListeners = new CopyOnWriteArrayList<ActionListener>();
    private final List<ClassPathSupport.Item> runModulePathExtension;

    J2SEProject getProject() {
        return this.project;
    }

    public J2SEProjectProperties(J2SEProject project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper, GeneratedFilesHelper genFileHelper) {
        this.project = project;
        this.updateHelper = updateHelper;
        this.evaluator = evaluator;
        this.refHelper = refHelper;
        this.genFileHelper = genFileHelper;
        this.cs = new ClassPathSupport(evaluator, refHelper, updateHelper.getAntProjectHelper(), updateHelper, null);
        this.privateGroup = new StoreGroup();
        this.projectGroup = new StoreGroup();
        this.additionalProperties = new HashMap<String, String>();
        this.runModulePathExtension = new ArrayList<ClassPathSupport.Item>();
        this.init();
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    private void init() {
        this.CLASS_PATH_LIST_RENDERER = ClassPathListCellRenderer.createClassPathListRenderer(this.evaluator, this.project.getProjectDirectory());
        this.SOURCE_ROOTS_MODEL = SourceRootsUi.createModel(this.project.getSourceRoots());
        this.TEST_ROOTS_MODEL = SourceRootsUi.createModel(this.project.getTestSourceRoots());
        this.includes = this.evaluator.getProperty("includes");
        if (this.includes == null) {
            this.includes = "**";
        }
        this.excludes = this.evaluator.getProperty("excludes");
        if (this.excludes == null) {
            this.excludes = "";
        }
        EditableProperties projectProperties = this.updateHelper.getProperties("nbproject/project.properties");
        this.JAVAC_MODULEPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator(projectProperties.get("javac.modulepath")));
        this.JAVAC_CLASSPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator(projectProperties.get("javac.classpath")));
        String processorPath = projectProperties.get("javac.processorpath");
        processorPath = processorPath == null ? "${javac.classpath}" : processorPath;
        this.JAVAC_PROCESSORPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator(processorPath));
        this.JAVAC_PROCESSORMODULEPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator(projectProperties.get("javac.processormodulepath")));
        this.JAVAC_TEST_MODULEPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator(projectProperties.get("javac.test.modulepath")));
        this.JAVAC_TEST_CLASSPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator(projectProperties.get("javac.test.classpath")));
        this.RUN_MODULEPATH_MODEL = ClassPathUiSupport.createListModel(this.createExtendedPathItems(projectProperties, "run.modulepath", null, this.isNamedModule() ? "build.classes.dir" : null, this.runModulePathExtension));
        this.RUN_CLASSPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator(projectProperties.get("run.classpath")));
        this.RUN_TEST_MODULEPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator(projectProperties.get("run.test.modulepath")));
        this.RUN_TEST_CLASSPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator(projectProperties.get("run.test.classpath")));
        this.ENDORSED_CLASSPATH_MODEL = ClassPathUiSupport.createListModel(this.cs.itemsIterator(projectProperties.get("endorsed.classpath")));
        Collection<PlatformFilter> filters = this.project.getLookup().lookupAll(PlatformFilter.class);
        this.PLATFORM_MODEL = PlatformUiSupport.createPlatformComboBoxModel(this.project, this.evaluator, this.evaluator.getProperty("platform.active"), filters);
        this.PLATFORM_LIST_RENDERER = PlatformUiSupport.createPlatformListCellRenderer();
        this.JAVAC_SOURCE_MODEL = PlatformUiSupport.createSourceLevelComboBoxModel(this.PLATFORM_MODEL, this.evaluator.getProperty("javac.source"), this.evaluator.getProperty("javac.target"));
        this.JAVAC_SOURCE_RENDERER = PlatformUiSupport.createSourceLevelListCellRenderer();
        this.JAVAC_PROFILE_MODEL = PlatformUiSupport.createProfileComboBoxModel(this.JAVAC_SOURCE_MODEL, this.evaluator.getProperty("javac.profile"), null);
        this.JAVAC_PROFILE_RENDERER = PlatformUiSupport.createProfileListCellRenderer();
        this.SHARED_LIBRARIES_MODEL = new PlainDocument();
        try {
            this.SHARED_LIBRARIES_MODEL.insertString(0, this.project.getAntProjectHelper().getLibrariesLocation(), null);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace(ex);
        }
        this.JAVAC_DEPRECATION_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, "javac.deprecation");
        Integer[] kind = new Integer[1];
        this.JAVAC_DEBUG_MODEL = J2SEProjectProperties.createToggleButtonModel(this.evaluator, "javac.debug", true, kind);
        this.javacDebugBooleanKind = kind[0];
        this.DO_DEPEND_MODEL = this.privateGroup.createToggleButtonModel(this.evaluator, "do.depend");
        this.COMPILE_ON_SAVE_MODEL = this.privateGroup.createToggleButtonModel(this.evaluator, "compile.on.save");
        this.NO_DEPENDENCIES_MODEL = this.projectGroup.createInverseToggleButtonModel(this.evaluator, "no.dependencies");
        this.ENABLE_ANNOTATION_PROCESSING_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, "annotation.processing.enabled");
        this.ENABLE_ANNOTATION_PROCESSING_IN_EDITOR_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, "annotation.processing.enabled.in.editor");
        String annotationProcessors = projectProperties.get("annotation.processing.processors.list");
        if (annotationProcessors == null) {
            annotationProcessors = "";
        }
        this.ANNOTATION_PROCESSORS_MODEL = ClassPathUiSupport.createListModel((annotationProcessors.length() > 0 ? Arrays.asList(annotationProcessors.split(",")) : Collections.emptyList()).iterator());
        String processorOptions = projectProperties.get("annotation.processing.processor.options");
        if (processorOptions == null) {
            processorOptions = "";
        }
        this.PROCESSOR_OPTIONS_MODEL = new DefaultTableModel(new String[0][], new String[]{NbBundle.getMessage(CustomizerCompile.class, "LBL_CustomizeCompile_Processor_Options_Key"), NbBundle.getMessage(CustomizerCompile.class, "LBL_CustomizeCompile_Processor_Options_Value")}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        for (String option : processorOptions.split("\\s")) {
            if (!option.startsWith("-A") || option.length() <= 2) continue;
            int sepIndex = option.indexOf(61);
            String key = null;
            String value = null;
            if (sepIndex == -1) {
                key = option.substring(2);
            } else if (sepIndex >= 3) {
                key = option.substring(2, sepIndex);
                value = sepIndex < option.length() - 1 ? option.substring(sepIndex + 1) : null;
            }
            this.PROCESSOR_OPTIONS_MODEL.addRow(new String[]{key, value});
        }
        this.JAVAC_EXTERNAL_VM_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, JAVAC_EXTERNAL_VM);
        this.JAVAC_COMPILER_ARG_MODEL = this.projectGroup.createStringDocument(this.evaluator, "javac.compilerargs");
        this.DIST_JAR_MODEL = this.projectGroup.createStringDocument(this.evaluator, "dist.jar");
        this.BUILD_CLASSES_EXCLUDES_MODEL = this.projectGroup.createStringDocument(this.evaluator, "build.classes.excludes");
        this.JAR_COMPRESS_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, "jar.compress");
        this.DO_JAR_MODEL = J2SEProjectProperties.createToggleButtonModel(this.evaluator, "do.jar", true, kind);
        this.doJarBooleanKind = kind[0];
        this.COPY_LIBS_MODEL = this.projectGroup.createInverseToggleButtonModel(this.evaluator, MKDIST_DISABLED);
        this.JLINK_MODEL = J2SEProjectProperties.createToggleButtonModel(this.evaluator, "do.jlink", false, kind);
        this.doJLinkKind = kind[0];
        this.JLINK_STRIP_MODEL = J2SEProjectProperties.createToggleButtonModel(this.evaluator, "jlink.strip", false, kind);
        this.jLinkStripKind = kind[0];
        this.JLINK_LAUNCHER_MODEL = J2SEProjectProperties.createToggleButtonModel(this.evaluator, "jlink.launcher", false, kind);
        this.jLinkLauncherKind = kind[0];
        this.JLINK_LAUNCHER_NAME_MODEL = this.projectGroup.createStringDocument(this.evaluator, "jlink.launcher.name");
        String launcherName = this.evaluator.getProperty("jlink.launcher.name");
        if (launcherName == null) {
            try {
                this.JLINK_LAUNCHER_NAME_MODEL.insertString(0, PropertyUtils.getUsablePropertyName(ProjectUtils.getInformation(this.project).getDisplayName()), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.JAVADOC_PRIVATE_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, "javadoc.private");
        this.JAVADOC_NO_TREE_MODEL = this.projectGroup.createInverseToggleButtonModel(this.evaluator, "javadoc.notree");
        this.JAVADOC_USE_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, "javadoc.use");
        this.JAVADOC_NO_NAVBAR_MODEL = this.projectGroup.createInverseToggleButtonModel(this.evaluator, "javadoc.nonavbar");
        this.JAVADOC_NO_INDEX_MODEL = this.projectGroup.createInverseToggleButtonModel(this.evaluator, "javadoc.noindex");
        this.JAVADOC_SPLIT_INDEX_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, "javadoc.splitindex");
        this.JAVADOC_HTML5_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, "javadoc.html5");
        this.JAVADOC_AUTHOR_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, "javadoc.author");
        this.JAVADOC_VERSION_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, "javadoc.version");
        this.JAVADOC_WINDOW_TITLE_MODEL = this.projectGroup.createStringDocument(this.evaluator, "javadoc.windowtitle");
        this.JAVADOC_PREVIEW_MODEL = J2SEProjectProperties.createToggleButtonModel(this.evaluator, "javadoc.preview", true, kind);
        this.javadocPreviewBooleanKind = kind[0];
        this.JAVADOC_ADDITIONALPARAM_MODEL = this.projectGroup.createStringDocument(this.evaluator, "javadoc.additionalparam");
        this.APPLICATION_TITLE_DOC = this.projectGroup.createStringDocument(this.evaluator, APPLICATION_TITLE);
        String title = this.evaluator.getProperty(APPLICATION_TITLE);
        if (title == null) {
            try {
                this.APPLICATION_TITLE_DOC.insertString(0, ProjectUtils.getInformation(this.project).getDisplayName(), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.APPLICATION_VENDOR_DOC = this.projectGroup.createStringDocument(this.evaluator, APPLICATION_VENDOR);
        String vendor = this.evaluator.getProperty(APPLICATION_VENDOR);
        if (vendor == null) {
            try {
                this.APPLICATION_VENDOR_DOC.insertString(0, System.getProperty("user.name", "User Name"), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.APPLICATION_DESC_DOC = this.projectGroup.createStringDocument(this.evaluator, APPLICATION_DESC);
        this.APPLICATION_HOMEPAGE_DOC = this.projectGroup.createStringDocument(this.evaluator, APPLICATION_HOMEPAGE);
        this.APPLICATION_SPLASH_DOC = this.projectGroup.createStringDocument(this.evaluator, APPLICATION_SPLASH);
        this.LICENSE_PATH_VALUE = projectProperties.get("project.licensePath");
        this.LICENSE_NAME_VALUE = projectProperties.get("project.license");
        this.CHANGED_LICENSE_PATH_CONTENT = null;
        if (!this.isFXProject()) {
            this.RUN_CONFIGS = this.readRunConfigs();
            this.activeConfig = this.evaluator.getProperty("config");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            this.saveLibrariesLocation();
            if (this.CHANGED_LICENSE_PATH_CONTENT != null) {
                String path = this.LICENSE_PATH_VALUE;
                assert (path != null);
                String evaluated = this.getEvaluator().evaluate(path);
                File file = this.project.getAntProjectHelper().resolveFile(evaluated);
                FileObject fo = !file.exists() ? FileUtil.createData(file) : FileUtil.toFileObject(file);
                try (OutputStream out = fo.getOutputStream();){
                    FileUtil.copy(new ByteArrayInputStream(this.CHANGED_LICENSE_PATH_CONTENT.getBytes()), out);
                }
            }
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    J2SEProjectProperties.this.storeProperties();
                    if (!J2SEProjectProperties.this.COMPILE_ON_SAVE_MODEL.isSelected()) {
                        String buildClassesDir = J2SEProjectProperties.this.evaluator.getProperty("build.classes.dir");
                        if (buildClassesDir == null) {
                            StringBuilder logRecord = new StringBuilder();
                            logRecord.append("EVALUATOR: " + J2SEProjectProperties.this.evaluator.getProperties().toString() + ";");
                            logRecord.append("PROJECT_PROPS: " + J2SEProjectProperties.this.updateHelper.getProperties("nbproject/project.properties").entrySet() + ";");
                            logRecord.append("PRIVATE_PROPS: " + J2SEProjectProperties.this.updateHelper.getProperties("nbproject/private/private.properties").entrySet() + ";");
                            assert (buildClassesDir != null) : logRecord.toString();
                            LOG.warning("No build.classes.dir property: " + logRecord.toString());
                        } else {
                            FileObject mark;
                            FileObject buildClasses = J2SEProjectProperties.this.updateHelper.getAntProjectHelper().resolveFileObject(buildClassesDir);
                            if (buildClasses != null && (mark = buildClasses.getFileObject(J2SEProjectProperties.COS_MARK)) != null) {
                                final ActionProvider ap = J2SEProjectProperties.this.project.getLookup().lookup(ActionProvider.class);
                                assert (ap != null);
                                Mutex.EVENT.writeAccess(new Runnable(){

                                    @Override
                                    public void run() {
                                        ap.invokeAction("clean", Lookups.fixed(J2SEProjectProperties.this.project));
                                    }
                                });
                            }
                        }
                    }
                    return null;
                }
            });
            this.project.setProjectPropertiesSave(true);
            try {
                ProjectManager.getDefault().saveProject(this.project);
            }
            finally {
                this.project.setProjectPropertiesSave(false);
            }
        }
        catch (MutexException e) {
            ErrorManager.getDefault().notify((IOException)e.getException());
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(ex);
        }
    }

    private void saveLibrariesLocation() throws IOException, IllegalArgumentException {
        try {
            String old;
            String str = this.SHARED_LIBRARIES_MODEL.getText(0, this.SHARED_LIBRARIES_MODEL.getLength()).trim();
            if (str.length() == 0) {
                str = null;
            }
            if (!((old = this.project.getAntProjectHelper().getLibrariesLocation()) == null && str == null || old != null && old.equals(str))) {
                this.project.getAntProjectHelper().setLibrariesLocation(str);
                ProjectManager.getDefault().saveProject(this.project);
            }
        }
        catch (BadLocationException x) {
            ErrorManager.getDefault().notify(x);
        }
    }

    private void storeProperties() throws IOException {
        this.resolveProjectDependencies();
        String[] javac_mp = this.cs.encodeToStrings(ClassPathUiSupport.getList(this.JAVAC_MODULEPATH_MODEL));
        String[] javac_cp = this.cs.encodeToStrings(ClassPathUiSupport.getList(this.JAVAC_CLASSPATH_MODEL));
        String[] javac_pmp = this.cs.encodeToStrings(ClassPathUiSupport.getList(this.JAVAC_PROCESSORMODULEPATH_MODEL));
        String[] javac_pp = this.cs.encodeToStrings(ClassPathUiSupport.getList(this.JAVAC_PROCESSORPATH_MODEL));
        String[] javac_test_mp = this.cs.encodeToStrings(ClassPathUiSupport.getList(this.JAVAC_TEST_MODULEPATH_MODEL));
        String[] javac_test_cp = this.cs.encodeToStrings(ClassPathUiSupport.getList(this.JAVAC_TEST_CLASSPATH_MODEL));
        ArrayList<ClassPathSupport.Item> l = new ArrayList<ClassPathSupport.Item>(ClassPathUiSupport.getList(this.RUN_MODULEPATH_MODEL));
        l.removeAll(this.runModulePathExtension);
        String[] run_mp = this.cs.encodeToStrings(l);
        String[] run_cp = this.cs.encodeToStrings(ClassPathUiSupport.getList(this.RUN_CLASSPATH_MODEL));
        String[] run_test_mp = this.cs.encodeToStrings(ClassPathUiSupport.getList(this.RUN_TEST_MODULEPATH_MODEL));
        String[] run_test_cp = this.cs.encodeToStrings(ClassPathUiSupport.getList(this.RUN_TEST_CLASSPATH_MODEL));
        String[] endorsed_cp = this.cs.encodeToStrings(ClassPathUiSupport.getList(this.ENDORSED_CLASSPATH_MODEL));
        this.storeRoots(this.project.getSourceRoots(), this.SOURCE_ROOTS_MODEL);
        this.storeRoots(this.project.getTestSourceRoots(), this.TEST_ROOTS_MODEL);
        EditableProperties projectProperties = this.updateHelper.getProperties("nbproject/project.properties");
        EditableProperties privateProperties = this.updateHelper.getProperties("nbproject/private/private.properties");
        if (!this.JAVADOC_NO_INDEX_MODEL.isSelected()) {
            this.JAVADOC_SPLIT_INDEX_MODEL.setSelected(false);
        }
        this.projectGroup.store(projectProperties);
        this.privateGroup.store(privateProperties);
        if (this.LICENSE_PATH_VALUE != null) {
            projectProperties.setProperty("project.licensePath", this.LICENSE_PATH_VALUE);
        } else {
            projectProperties.remove("project.licensePath");
        }
        if (this.LICENSE_NAME_VALUE != null) {
            projectProperties.setProperty("project.license", this.LICENSE_NAME_VALUE);
        } else {
            projectProperties.remove("project.license");
        }
        boolean isFXProject = this.isFXProject();
        if (!isFXProject) {
            this.storeRunConfigs(this.RUN_CONFIGS, projectProperties, privateProperties);
            EditableProperties ep = this.updateHelper.getProperties("nbproject/private/config.properties");
            if (this.activeConfig == null) {
                ep.remove("config");
            } else {
                ep.setProperty("config", this.activeConfig);
            }
            this.updateHelper.putProperties("nbproject/private/config.properties", ep);
        }
        privateProperties.setProperty("javac.debug", J2SEProjectProperties.encodeBoolean(this.JAVAC_DEBUG_MODEL.isSelected(), this.javacDebugBooleanKind));
        privateProperties.setProperty("do.jar", J2SEProjectProperties.encodeBoolean(this.DO_JAR_MODEL.isSelected(), this.doJarBooleanKind));
        privateProperties.setProperty("do.jlink", J2SEProjectProperties.encodeBoolean(this.JLINK_MODEL.isSelected(), this.doJLinkKind));
        privateProperties.setProperty("jlink.strip", J2SEProjectProperties.encodeBoolean(this.JLINK_STRIP_MODEL.isSelected(), this.jLinkStripKind));
        projectProperties.setProperty("jlink.launcher", J2SEProjectProperties.encodeBoolean(this.JLINK_LAUNCHER_MODEL.isSelected(), this.jLinkLauncherKind));
        privateProperties.setProperty("javadoc.preview", J2SEProjectProperties.encodeBoolean(this.JAVADOC_PREVIEW_MODEL.isSelected(), this.javadocPreviewBooleanKind));
        projectProperties.setProperty("javac.modulepath", javac_mp);
        projectProperties.setProperty("javac.classpath", javac_cp);
        projectProperties.setProperty("javac.processormodulepath", javac_pmp);
        projectProperties.setProperty("javac.processorpath", javac_pp);
        projectProperties.setProperty("javac.test.modulepath", javac_test_mp);
        projectProperties.setProperty("javac.test.classpath", javac_test_cp);
        projectProperties.setProperty("run.modulepath", run_mp);
        projectProperties.setProperty("run.classpath", run_cp);
        projectProperties.setProperty("run.test.modulepath", run_test_mp);
        projectProperties.setProperty("run.test.classpath", run_test_cp);
        projectProperties.setProperty("endorsed.classpath", endorsed_cp);
        PlatformUiSupport.storePlatform(projectProperties, this.updateHelper, "http://www.netbeans.org/ns/j2se-project/3", this.PLATFORM_MODEL.getSelectedItem(), this.JAVAC_SOURCE_MODEL.getSelectedItem(), this.JAVAC_PROFILE_MODEL.getSelectedItem(), !isFXProject);
        if (this.NO_DEPENDENCIES_MODEL.isSelected()) {
            projectProperties.remove("no.dependencies");
        }
        projectProperties.putAll(this.additionalProperties);
        projectProperties.put("includes", this.includes);
        projectProperties.put("excludes", this.excludes);
        StringBuilder sb = new StringBuilder();
        Enumeration elements = this.ANNOTATION_PROCESSORS_MODEL.elements();
        while (elements.hasMoreElements()) {
            sb.append(elements.nextElement());
            if (!elements.hasMoreElements()) continue;
            sb.append(',');
        }
        if (sb.length() > 0) {
            projectProperties.put("annotation.processing.run.all.processors", J2SEProjectProperties.encodeBoolean(false, BOOLEAN_KIND_TF));
            projectProperties.put("annotation.processing.processors.list", sb.toString());
        } else {
            projectProperties.put("annotation.processing.run.all.processors", J2SEProjectProperties.encodeBoolean(true, BOOLEAN_KIND_TF));
            projectProperties.put("annotation.processing.processors.list", "");
        }
        sb = new StringBuilder();
        for (int i = 0; i < this.PROCESSOR_OPTIONS_MODEL.getRowCount(); ++i) {
            String key = (String)this.PROCESSOR_OPTIONS_MODEL.getValueAt(i, 0);
            String value = (String)this.PROCESSOR_OPTIONS_MODEL.getValueAt(i, 1);
            sb.append("-A").append(key);
            if (value != null && value.length() > 0) {
                sb.append('=').append(value);
            }
            if (i >= this.PROCESSOR_OPTIONS_MODEL.getRowCount() - 1) continue;
            sb.append(' ');
        }
        if (sb.length() > 0) {
            projectProperties.put("annotation.processing.processor.options", sb.toString());
        } else {
            projectProperties.remove("annotation.processing.processor.options");
        }
        this.updateHelper.putProperties("nbproject/project.properties", projectProperties);
        this.updateHelper.putProperties("nbproject/private/private.properties", privateProperties);
        String value = this.additionalProperties.get("source.encoding");
        if (value != null) {
            try {
                FileEncodingQuery.setDefaultEncoding(Charset.forName(value));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
    }

    private void resolveProjectDependencies() {
        HashSet<ClassPathSupport.Item> oldArtifacts = new HashSet<ClassPathSupport.Item>();
        EditableProperties projectProperties = this.updateHelper.getProperties("nbproject/project.properties");
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get("javac.modulepath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get("javac.classpath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get("javac.processormodulepath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get("javac.processorpath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get("javac.test.modulepath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get("javac.test.classpath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get("run.modulepath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get("run.classpath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get("run.test.modulepath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get("run.test.classpath")));
        oldArtifacts.addAll(this.cs.itemsList(projectProperties.get("endorsed.classpath")));
        HashSet<ClassPathSupport.Item> newArtifacts = new HashSet<ClassPathSupport.Item>();
        newArtifacts.addAll(ClassPathUiSupport.getList(this.JAVAC_MODULEPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.JAVAC_CLASSPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.JAVAC_PROCESSORMODULEPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.JAVAC_PROCESSORPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.JAVAC_TEST_MODULEPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.JAVAC_TEST_CLASSPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.RUN_MODULEPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.RUN_CLASSPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.RUN_TEST_MODULEPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.RUN_TEST_CLASSPATH_MODEL));
        newArtifacts.addAll(ClassPathUiSupport.getList(this.ENDORSED_CLASSPATH_MODEL));
        HashSet removed = new HashSet(oldArtifacts);
        removed.removeAll(newArtifacts);
        HashSet added = new HashSet(newArtifacts);
        added.removeAll(oldArtifacts);
        for (ClassPathSupport.Item item : removed) {
            if (item.getType() != 2 && item.getType() != 0) continue;
            this.refHelper.destroyReference(item.getReference());
            if (item.getType() != 0) continue;
            item.removeSourceAndJavadoc(this.updateHelper);
        }
        boolean changed = false;
        EditableProperties ep = this.updateHelper.getProperties("nbproject/project.properties");
        for (ClassPathSupport.Item item : removed) {
            if (item.getType() != 1) continue;
            String prop = item.getReference();
            prop = CommonProjectUtils.getAntPropertyName(prop);
            ep.remove(prop);
            changed = true;
        }
        if (changed) {
            this.updateHelper.putProperties("nbproject/project.properties", ep);
        }
    }

    private void storeRoots(SourceRoots roots, DefaultTableModel tableModel) throws MalformedURLException {
        Vector<Vector> data = tableModel.getDataVector();
        URL[] rootURLs = new URL[data.size()];
        String[] rootLabels = new String[data.size()];
        LinkedList<URL> oldRootURLs = new LinkedList<URL>(Arrays.asList(roots.getRootURLs(false)));
        LinkedList<String> oldRootLabels = new LinkedList<String>(Arrays.asList(roots.getRootNames()));
        LinkedList<String> oldRootProps = new LinkedList<String>(Arrays.asList(roots.getRootProperties()));
        boolean rootsAreSame = true;
        for (int i = 0; i < data.size(); ++i) {
            File f = (File)data.elementAt(i).elementAt(0);
            rootURLs[i] = Utilities.toURI(f).toURL();
            if (!rootURLs[i].toExternalForm().endsWith("/")) {
                rootURLs[i] = new URL(rootURLs[i] + "/");
            }
            this.validateURL(rootURLs[i], f);
            rootLabels[i] = (String)data.elementAt(i).elementAt(1);
            rootsAreSame &= !oldRootURLs.isEmpty() && oldRootURLs.removeFirst().equals(rootURLs[i]) && roots.getRootDisplayName(oldRootLabels.removeFirst(), oldRootProps.removeFirst()).equals(rootLabels[i]);
        }
        if (!rootsAreSame || !oldRootURLs.isEmpty()) {
            roots.putRoots(rootURLs, rootLabels);
        }
    }

    private void validateURL(URL url, File file) {
        try {
            URI uri = url.toURI();
            if (!uri.isAbsolute()) {
                throw new IllegalArgumentException("URI is not absolute: " + uri.toString() + " File: " + file.getAbsolutePath());
            }
            if (uri.isOpaque()) {
                throw new IllegalArgumentException("URI is not hierarchical: " + uri.toString() + " File: " + file.getAbsolutePath());
            }
            if (!"file".equals(uri.getScheme())) {
                throw new IllegalArgumentException("URI scheme is not \"file\": " + uri.toString() + " File: " + file.getAbsolutePath());
            }
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(use);
        }
    }

    public void putAdditionalProperty(String propertyName, String propertyValue) {
        this.additionalProperties.put(propertyName, propertyValue);
    }

    private static String encodeBoolean(boolean value, Integer kind) {
        if (kind == BOOLEAN_KIND_ED) {
            return value ? "on" : "off";
        }
        if (kind == BOOLEAN_KIND_YN) {
            return value ? "yes" : "no";
        }
        return value ? "true" : "false";
    }

    private static JToggleButton.ToggleButtonModel createToggleButtonModel(@NonNull PropertyEvaluator evaluator, @NonNull String propName, boolean defaultValue, @NonNull Integer[] kind) {
        assert (evaluator != null);
        assert (propName != null);
        assert (kind != null && kind.length == 1);
        String value = evaluator.getProperty(propName);
        boolean isSelected = false;
        if (value == null) {
            isSelected = defaultValue;
        } else {
            String lowercaseValue = value.toLowerCase();
            kind[0] = lowercaseValue.equals("yes") || lowercaseValue.equals("no") ? BOOLEAN_KIND_YN : (lowercaseValue.equals("on") || lowercaseValue.equals("off") ? BOOLEAN_KIND_ED : BOOLEAN_KIND_TF);
            if (lowercaseValue.equals("true") || lowercaseValue.equals("yes") || lowercaseValue.equals("on")) {
                isSelected = true;
            }
        }
        JToggleButton.ToggleButtonModel bm = new JToggleButton.ToggleButtonModel();
        bm.setSelected(isSelected);
        return bm;
    }

    Map<String, Map<String, String>> readRunConfigs() {
        TreeMap<String, Map<String, String>> m = new TreeMap<String, Map<String, String>>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1 != null ? (s2 != null ? s1.compareTo(s2) : 1) : (s2 != null ? -1 : 0);
            }
        });
        TreeMap<String, String> def = new TreeMap<String, String>();
        for (String prop : CONFIG_AWARE_PROPERTIES) {
            String v = this.updateHelper.getProperties("nbproject/private/private.properties").getProperty(prop);
            if (v == null) {
                v = this.updateHelper.getProperties("nbproject/project.properties").getProperty(prop);
            }
            if (v == null) continue;
            def.put(prop, v);
        }
        m.put(null, def);
        FileObject configs = this.project.getProjectDirectory().getFileObject("nbproject/configs");
        if (configs != null) {
            for (FileObject kid : configs.getChildren()) {
                String relPath;
                if (!kid.hasExt("properties") || (relPath = FileUtil.getRelativePath(this.project.getProjectDirectory(), kid)) == null) continue;
                m.put(kid.getName(), new TreeMap<String, String>(this.updateHelper.getProperties(relPath)));
            }
        }
        if ((configs = this.project.getProjectDirectory().getFileObject("nbproject/private/configs")) != null) {
            for (FileObject kid : configs.getChildren()) {
                String relPath;
                Map c;
                if (!kid.hasExt("properties") || (c = (Map)m.get(kid.getName())) == null || (relPath = FileUtil.getRelativePath(this.project.getProjectDirectory(), kid)) == null) continue;
                c.putAll(new HashMap<String, String>(this.updateHelper.getProperties(relPath)));
            }
        }
        return m;
    }

    void storeRunConfigs(Map<String, Map<String, String>> configs, EditableProperties projectProperties, EditableProperties privateProperties) throws IOException {
        Map<String, String> def = configs.get(null);
        for (String prop : CONFIG_AWARE_PROPERTIES) {
            EditableProperties ep;
            String v = def.get(prop);
            EditableProperties editableProperties = ep = prop.equals("application.args") || prop.equals("work.dir") || privateProperties.containsKey(prop) ? privateProperties : projectProperties;
            if (Utilities.compareObjects(v, ep.getProperty(prop))) continue;
            if (v != null && v.length() > 0) {
                ep.setProperty(prop, v);
                continue;
            }
            ep.remove(prop);
        }
        for (Map.Entry entry : configs.entrySet()) {
            String config = (String)entry.getKey();
            if (config == null) continue;
            String sharedPath = "nbproject/configs/" + config + ".properties";
            String privatePath = "nbproject/private/configs/" + config + ".properties";
            Map c = (Map)entry.getValue();
            if (c == null) {
                this.updateHelper.putProperties(sharedPath, null);
                this.updateHelper.putProperties(privatePath, null);
                continue;
            }
            EditableProperties sharedCfgProps = this.updateHelper.getProperties(sharedPath);
            EditableProperties privateCfgProps = this.updateHelper.getProperties(privatePath);
            boolean privatePropsChanged = false;
            for (Map.Entry entry2 : c.entrySet()) {
                EditableProperties ep;
                String prop = (String)entry2.getKey();
                String v = (String)entry2.getValue();
                if (Utilities.compareObjects(v, (ep = prop.equals("application.args") || prop.equals("work.dir") || privateCfgProps.containsKey(prop) ? privateCfgProps : sharedCfgProps).getProperty(prop))) continue;
                if (v != null && (v.length() > 0 || def.get(prop) != null && def.get(prop).length() > 0)) {
                    ep.setProperty(prop, v);
                } else {
                    ep.remove(prop);
                }
                privatePropsChanged |= ep == privateCfgProps;
            }
            this.updateHelper.putProperties(sharedPath, sharedCfgProps);
            if (!privatePropsChanged) continue;
            this.updateHelper.putProperties(privatePath, privateCfgProps);
        }
    }

    boolean isFXProject() {
        return J2SEProjectUtil.isTrue(this.evaluator.getProperty("javafx.enabled"));
    }

    void loadIncludesExcludes(IncludeExcludeVisualizer v) {
        HashSet<File> roots = new HashSet<File>();
        for (DefaultTableModel model : new DefaultTableModel[]{this.SOURCE_ROOTS_MODEL, this.TEST_ROOTS_MODEL}) {
            for (Vector row : model.getDataVector()) {
                File d = (File)row.elementAt(0);
                if (!d.isDirectory()) continue;
                roots.add(d);
            }
        }
        v.setRoots(roots.toArray(new File[roots.size()]));
        v.setIncludePattern(this.includes);
        v.setExcludePattern(this.excludes);
    }

    void storeIncludesExcludes(IncludeExcludeVisualizer v) {
        this.includes = v.getIncludePattern();
        this.excludes = v.getExcludePattern();
    }

    boolean makeSharable() {
        ArrayList<String> libs = new ArrayList<String>();
        ArrayList<String> jars = new ArrayList<String>();
        this.collectLibs(this.JAVAC_CLASSPATH_MODEL, libs, jars);
        this.collectLibs(this.JAVAC_PROCESSORPATH_MODEL, libs, jars);
        this.collectLibs(this.JAVAC_TEST_CLASSPATH_MODEL, libs, jars);
        this.collectLibs(this.RUN_CLASSPATH_MODEL, libs, jars);
        this.collectLibs(this.RUN_TEST_CLASSPATH_MODEL, libs, jars);
        this.collectLibs(this.ENDORSED_CLASSPATH_MODEL, libs, jars);
        libs.add("CopyLibs");
        String customTasksLibs = this.getProject().evaluator().getProperty("ant.customtasks.libs");
        if (customTasksLibs != null) {
            String[] libIDs;
            for (String libID : libIDs = customTasksLibs.split(",")) {
                libs.add(libID.trim());
            }
        }
        return SharableLibrariesUtils.showMakeSharableWizard(this.getProject().getAntProjectHelper(), this.getProject().getReferenceHelper(), libs, jars);
    }

    private void collectLibs(DefaultListModel model, List<String> libs, List<String> jarReferences) {
        for (int i = 0; i < model.size(); ++i) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)model.get(i);
            if (item.getType() == 1 && !item.isBroken() && !libs.contains(item.getLibrary().getName())) {
                libs.add(item.getLibrary().getName());
            }
            if (item.getType() != 0 || item.getReference() == null || item.getVariableBasedProperty() != null || jarReferences.contains(item.getReference())) continue;
            jarReferences.add(item.getReference());
        }
    }

    @NonNull
    Iterable<? extends ActionListener> getOptionListeners() {
        return this.optionListeners;
    }

    void addOptionListener(@NonNull ActionListener al) {
        Parameters.notNull("al", al);
        this.optionListeners.add(al);
    }

    void removeOptionListener(@NonNull ActionListener al) {
        Parameters.notNull("al", al);
        this.optionListeners.remove(al);
    }

    private boolean isNamedModule() {
        String sl = SourceLevelQuery.getSourceLevel2(this.project.getProjectDirectory()).getSourceLevel();
        if (sl == null || JDK9.compareTo(new SpecificationVersion(sl)) > 0) {
            return false;
        }
        return J2SEProjectUtil.hasModuleInfo(this.project.getSourceRoots());
    }

    @NonNull
    private Iterator<ClassPathSupport.Item> createExtendedPathItems(@NonNull EditableProperties projectProperties, @NonNull String propertyName, @NullAllowed String prependPropertyName, @NullAllowed String appendPropertyName, @NonNull Collection<? super ClassPathSupport.Item> patch) {
        ClassPathSupport.Item i;
        boolean newItem;
        Iterator<ClassPathSupport.Item> base = this.cs.itemsIterator(projectProperties.get(propertyName));
        if (prependPropertyName == null && appendPropertyName == null) {
            return base;
        }
        ArrayList<ClassPathSupport.Item> extended = new ArrayList<ClassPathSupport.Item>();
        Set artefacts = Arrays.stream(PropertyUtils.tokenizePath(this.evaluator.getProperty(propertyName))).map(p -> this.updateHelper.getAntProjectHelper().resolveFile((String)p)).collect(Collectors.toSet());
        if (prependPropertyName != null && (newItem = Optional.ofNullable(this.evaluator.getProperty(prependPropertyName)).map(p -> this.updateHelper.getAntProjectHelper().resolveFile((String)p)).filter(f -> !artefacts.contains(f)).isPresent())) {
            i = ClassPathSupport.Item.create(String.format("${%s}", prependPropertyName));
            patch.add(i);
            extended.add(i);
        }
        base.forEachRemaining(extended::add);
        if (appendPropertyName != null && (newItem = Optional.ofNullable(this.evaluator.getProperty(appendPropertyName)).map(p -> this.updateHelper.getAntProjectHelper().resolveFile((String)p)).filter(f -> !artefacts.contains(f)).isPresent())) {
            i = ClassPathSupport.Item.create(String.format("${%s}", appendPropertyName));
            patch.add(i);
            extended.add(i);
        }
        return Collections.unmodifiableList(extended).iterator();
    }
}

