/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.micronaut.newproject;

/**
 *
 * @author Dusan Balek
 */
public class FeatureTogglePanel extends javax.swing.JPanel {

    private final MicronautLaunchService.Feature feature;

    /**
     * Creates new form FeatureTogglePanel
     */
    public FeatureTogglePanel(MicronautLaunchService.Feature feature) {
        this.feature = feature;
        initComponents();
    }

    public MicronautLaunchService.Feature getFeature() {
        return feature;
    }

    public boolean isSelected() {
        return featureCheckBox.isSelected();
    }

    public void setSelected(boolean b) {
        featureCheckBox.setSelected(b);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        featureCheckBox = new javax.swing.JCheckBox();
        descriptionLabel = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(featureCheckBox, feature.getTitle());

        descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(descriptionLabel.getFont().getStyle() & ~java.awt.Font.BOLD, descriptionLabel.getFont().getSize()-1));
        org.openide.awt.Mnemonics.setLocalizedText(descriptionLabel, feature.getDescription());

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(featureCheckBox)
            .addGroup(layout.createSequentialGroup()
                .addGap(21, 21, 21)
                .addComponent(descriptionLabel))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(featureCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(descriptionLabel))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel descriptionLabel;
    private javax.swing.JCheckBox featureCheckBox;
    // End of variables declaration//GEN-END:variables
}
