/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum KeystoreType {
    BCFKS("BCFKS", "Bouncy Castle FIPS Keystore"),
    PKCS12("PKCS12", "PKCS12 Keystore"),
    JKS("JKS", "Java Keystore");

    private final String type;
    private final String description;

    private KeystoreType(String type, String description) {
        this.type = type;
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getType();
    }

    public static boolean isValidKeystoreType(String type) {
        if (type == null || type.replaceAll("\\s", "").isEmpty()) {
            return false;
        }
        return Arrays.stream(KeystoreType.values()).map(kt -> kt.getType().toLowerCase()).collect(Collectors.toList()).contains(type.toLowerCase());
    }
}

