/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.flow;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiActivateCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleEntity;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleRunStatusEntity;
import org.apache.nifi.web.api.entity.FlowAnalysisRulesEntity;

public class EnableFlowAnalysisRules
extends AbstractNiFiActivateCommand<FlowAnalysisRuleEntity, FlowAnalysisRuleRunStatusEntity> {
    public EnableFlowAnalysisRules() {
        super("enable-flow-analysis-rules");
    }

    @Override
    public String getDescription() {
        return "Attempts to enable one or all flow analysis rule(s). In stand-alone mode this command will not produce all of the output seen in interactive mode unless the --verbose argument is specified.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.FAR_ID.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String ruleId = this.getArg(properties, CommandOption.FAR_ID);
        HashSet<FlowAnalysisRuleEntity> ruleEntities = new HashSet<FlowAnalysisRuleEntity>();
        if (StringUtils.isBlank((CharSequence)ruleId)) {
            FlowAnalysisRulesEntity rulesEntity = client.getControllerClient().getFlowAnalysisRules();
            ruleEntities.addAll(rulesEntity.getFlowAnalysisRules());
        } else {
            ruleEntities.add(client.getControllerClient().getFlowAnalysisRule(ruleId));
        }
        this.activate(client, properties, ruleEntities, "ENABLED");
        return VoidResult.getInstance();
    }

    @Override
    public FlowAnalysisRuleRunStatusEntity getRunStatusEntity() {
        return new FlowAnalysisRuleRunStatusEntity();
    }

    @Override
    public FlowAnalysisRuleEntity activateComponent(NiFiClient client, FlowAnalysisRuleEntity ruleEntity, FlowAnalysisRuleRunStatusEntity runStatusEntity) throws NiFiClientException, IOException {
        return client.getControllerClient().activateFlowAnalysisRule(ruleEntity.getId(), runStatusEntity);
    }

    @Override
    public String getDispName(FlowAnalysisRuleEntity ruleEntity) {
        return "Flow analysis rule \"" + ruleEntity.getComponent().getName() + "\" (id: " + ruleEntity.getId() + ")";
    }
}

