/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.web.api.entity.AssetEntity;

public class CreateAsset
extends AbstractNiFiCommand<StringResult> {
    public CreateAsset() {
        super("create-asset", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates an asset in a given parameter context which can be referenced in a parameter.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
        this.addOption(CommandOption.ASSET_FILE.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        File assetFile = new File(this.getRequiredArg(properties, CommandOption.ASSET_FILE));
        ParamContextClient paramContextClient = client.getParamContextClient();
        AssetEntity assetEntity = paramContextClient.createAsset(paramContextId, assetFile.getName(), assetFile);
        return new StringResult(assetEntity.getAsset().getId(), this.isInteractive());
    }
}

