/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.minifi.toolkit.schema.ConfigSchema;
import org.apache.nifi.minifi.toolkit.schema.common.ConvertableSchema;
import org.apache.nifi.minifi.toolkit.schema.common.StringUtil;
import org.apache.nifi.minifi.toolkit.schema.exception.SchemaLoaderException;
import org.apache.nifi.minifi.toolkit.schema.v1.ConfigSchemaV1;
import org.apache.nifi.minifi.toolkit.schema.v2.ConfigSchemaV2;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class SchemaLoader {
    private static final Map<String, Function<Map, ConvertableSchema<ConfigSchema>>> configSchemaFactories = SchemaLoader.initConfigSchemaFactories();

    private static Map<String, Function<Map, ConvertableSchema<ConfigSchema>>> initConfigSchemaFactories() {
        HashMap<String, Function<Map, ConvertableSchema<ConfigSchema>>> result = new HashMap<String, Function<Map, ConvertableSchema<ConfigSchema>>>();
        result.put(String.valueOf(null), ConfigSchemaV1::new);
        result.put("", ConfigSchemaV1::new);
        result.put(Integer.toString(1), ConfigSchemaV1::new);
        result.put(Integer.toString(2), ConfigSchemaV2::new);
        result.put(Integer.toString(3), ConfigSchema::new);
        return result;
    }

    public static Map<String, Object> loadYamlAsMap(InputStream sourceStream) throws IOException, SchemaLoaderException {
        try {
            Yaml yaml = new Yaml();
            Object loadedObject = yaml.load(sourceStream);
            if (loadedObject instanceof Map) {
                Map map = (Map)loadedObject;
                return map;
            }
            try {
                throw new SchemaLoaderException("Provided YAML configuration is not a Map");
            }
            catch (YAMLException e) {
                throw new IOException(e);
            }
        }
        finally {
            sourceStream.close();
        }
    }

    public static void toYaml(ConfigSchema schema, Writer writer) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        Yaml yaml = new Yaml(options);
        yaml.dump(schema.toMap(), writer);
    }

    public static ConfigSchema loadConfigSchemaFromYaml(InputStream sourceStream) throws IOException, SchemaLoaderException {
        return SchemaLoader.loadConfigSchemaFromYaml(SchemaLoader.loadYamlAsMap(sourceStream));
    }

    public static ConfigSchema loadConfigSchemaFromYaml(Map<String, Object> yamlAsMap) throws SchemaLoaderException {
        return SchemaLoader.loadConvertableSchemaFromYaml(yamlAsMap).convert();
    }

    public static ConvertableSchema<ConfigSchema> loadConvertableSchemaFromYaml(InputStream inputStream) throws SchemaLoaderException, IOException {
        return SchemaLoader.loadConvertableSchemaFromYaml(SchemaLoader.loadYamlAsMap(inputStream));
    }

    public static ConvertableSchema<ConfigSchema> loadConvertableSchemaFromYaml(Map<String, Object> yamlAsMap) throws SchemaLoaderException {
        String version = String.valueOf(yamlAsMap.get("MiNiFi Config Version"));
        Function<Map, ConvertableSchema<ConfigSchema>> schemaFactory = configSchemaFactories.get(version);
        if (schemaFactory == null) {
            throw new SchemaLoaderException("YAML configuration version " + version + " not supported.  Supported versions: " + configSchemaFactories.keySet().stream().filter(s -> !StringUtil.isNullOrEmpty(s) && !String.valueOf(null).equals(s)).sorted().collect(Collectors.joining(", ")));
        }
        return schemaFactory.apply(yamlAsMap);
    }
}

